#include "/lib/all_the_libs.glsl"
varying vec2 texcoord;

#include "/global/post/bloom.glsl"
#include "/global/post/taa.glsl"

// Color grading, Bloom final, TAA final

vec3 film_grain(vec3 Color, vec2 Pos) {
    Pos.x += fract(float(frameCounter) / 4.14159) * 234;
    Pos.y -= fract(float(frameCounter) / 5.49382) * 567;
    Color += (texture2D(noisetex, Pos.xy / 255).rgb - 0.5) * FILM_GRAIN_STRENGTH;
    return Color;
}

vec3 apply_vignette(vec3 Color, vec2 Pos) {
    Pos = Pos - 0.5;
    float Strength = length(Pos * VIGNETTE_OPACITY);
    Strength = pow(Strength, 4 - VIGNETTE_FALLOFF);
    Color *= 1 - min(Strength, 1);
    return Color;
}
#if TAA_MODE != 0 || REFLECTIONS == 2
/* DRAWBUFFERS:04 */
#else
/* DRAWBUFFERS:0 */
#endif

void main() {
    vec4 Color = texture2D(colortex0, texcoord);
    bool IsDH;
    float Depth = get_depth_solid(texcoord, IsDH);

    #if TAA_MODE != 0
    gl_FragData[1].xyz = TAA(Color.rgb, vec3(texcoord, Depth), IsDH);
    #elif REFLECTIONS == 2
    gl_FragData[1] = Color;
    #endif

    #ifdef BLOOM
    float Offset = 0;
    vec3 FinalBloom = vec3(0);
    for (int i = 2; i < 2 + BLOOM_SIZE; i++) {
        FinalBloom += texture2D(colortex1, texcoord / exp2(i) + Offset).xyz;
        Offset += 1 / exp2(i);
    }
    FinalBloom /= BLOOM_SIZE;

    float BloomFactor = pow(get_luminance(FinalBloom), BLOOM_CURVE);
    BloomFactor += 0.2 * rainStrength * isIndoorsSmooth;

    Color.rgb = mix(Color.rgb, FinalBloom, BloomFactor * BLOOM_STRENGTH);
    #endif

    Color.rgb *= EXPOSURE;
    Color.rgb = apply_tonemap(Color.rgb);

    Color.rgb = pow(Color.rgb, vec3(1 / 2.2)); // Gamma correction
    Color.xyz += (bayer8(gl_FragCoord.xy) - 0.5) / 255;

    Color.rgb = apply_vibrance(Color.rgb, VIBRANCE);
    Color.rgb = apply_saturation(Color.rgb, SATURATION);
    Color.rgb = apply_contrast(Color.rgb, CONTRAST);

    vec3 MinBright = vec3(TONEMAP_MIN_R, TONEMAP_MIN_G, TONEMAP_MIN_B);
    Color.rgb = max(Color.rgb, MinBright);

    #ifdef FILM_GRAIN
    Color.rgb = film_grain(Color.rgb, gl_FragCoord.xy);
    #endif

    Color.rgb = apply_vignette(Color.rgb, texcoord);

    #if DEBUG_SHOW_BUFFER == 0
    gl_FragData[0] = Color;
    #elif DEBUG_SHOW_BUFFER == 1
    gl_FragData[0] = texelFetch2D(colortex1, ivec2(gl_FragCoord.xy), 0);
    #elif DEBUG_SHOW_BUFFER == 2
    gl_FragData[0] = texelFetch2D(noisetex, ivec2(gl_FragCoord.xy), 0);
    #elif DEBUG_SHOW_BUFFER == 3
    gl_FragData[0] = texelFetch2D(depthtex0, ivec2(gl_FragCoord.xy), 0);
    #else
    gl_FragData[0] = texelFetch(gaux1, ivec2(gl_FragCoord.xy), 0);
    #endif
}
