#include "/lib/all_the_libs.glsl"
#include "/global/post/bloom.glsl"

// Write to bloom buffer
const bool colortex0MipmapEnabled = true;

varying vec2 texcoord;

/* DRAWBUFFERS:1 */

void main() {
	gl_FragData[0] = vec4(0, 0, 0, 1);
	float BloomTile = is_in_range(texcoord);
	if(BloomTile != 0) {
		float Offset = 0;
		for(float i = 3; i <= BloomTile; i++)
			Offset += 1/exp2(i-1);
		gl_FragData[0].xyz = texture2D(colortex0, (texcoord-Offset)*exp2(BloomTile)).xyz;
	}
}
