float random(vec2 coords) {
    return fract(sin(dot(coords.xy, vec2(12.9898, 78.233))) * 43758.5453);
}

float random3D(vec3 p) {
    return fract(sin(dot(p, vec3(12.9898, 78.233, 45.543))) * 43758.5453);
}

vec3 project_and_divide(mat4 Projection_mat, vec3 x) {
    vec4 HomogeneousPos = Projection_mat * vec4(x, 1);
    return HomogeneousPos.xyz / HomogeneousPos.w;
}

// Ever so slightly faster & and gives the same result (i think)
vec2 normf(vec2 x) {
    float mag_sq = dot(x, x);
    float sqr = inversesqrt(mag_sq);
    return x*sqr;
}
vec3 normf(vec3 x) {
    float mag_sq = dot(x, x);
    float sqr = inversesqrt(mag_sq);
    return x*sqr;
}

vec3 to_view_pos(vec3 p, bool IsDH) {
    p = p * 2 - 1;
    if(IsDH)
        return project_and_divide(dhProjectionInverse, p);
    else
        return project_and_divide(gbufferProjectionInverse, p);
}

vec3 view_screen(vec3 x, bool IsDH) {
    if(IsDH)
        x = project_and_divide(dhProjection, x);
    else
        x = project_and_divide(gbufferProjection, x);
    x = x * 0.5 + 0.5;
    return x;
}

vec3 to_player_pos(vec3 p) {
    return mat3(gbufferModelViewInverse) * p;
}

vec3 player_view(vec3 p) {
    return mat3(gbufferModelView) * p;
}

// Code by Jessie: https://github.com/Jessie-LC/open-source-utility-code/blob/main/advanced/packing.glsl

vec2 encodeUnitVector(vec3 vector) {
    // Scale down to octahedron, project onto XY plane
    vector.xy /= abs(vector.x) + abs(vector.y) + abs(vector.z);
    // Reflect -Z hemisphere folds over the diagonals
    return vector.z <= 0.0 ? (1.0 - abs(vector.yx)) * vec2(vector.x >= 0.0 ? 1.0 : -1.0, vector.y >= 0.0 ? 1.0 : -1.0) : vector.xy;
}

vec3 decodeUnitVector(vec2 encoded) {
    // Exctract Z component
    vec3 vector = vec3(encoded, 1.0 - abs(encoded.x) - abs(encoded.y));
    // Reflect -Z hemisphere folds over the diagonals
    float t = max(-vector.z, 0.0);
    vector.xy += vec2(vector.x >= 0.0 ? -t : t, vector.y >= 0.0 ? -t : t);
    // Normalize and return
    return normf(vector);
}

float linearize_depth(float D) {
    return near / (1 - D);
}

float ld_exact(float depth, float near, float far) {
    return (near * far) / (depth * (near - far) + far);
}

float ld_exact(float depth, bool IsDH) {
    if(!IsDH)
        return (near * far) / (depth * (near - far) + far);
    else
        return (dhNearPlane * dhFarPlane) / (depth * (dhNearPlane - dhFarPlane) + dhFarPlane);
}

// Creates a TBN matrix from a normal and a tangent
mat3 tbnNormalTangent(vec3 normal, vec3 tangent) {
    // For DirectX normal mapping you want to switch the order of these
    vec3 bitangent = cross(normal, tangent);
    return mat3(tangent, bitangent, normal);
}

// Creates a TBN matrix from just a normal
// The tangent version is needed for normal mapping because
//   of face rotation
mat3 tbnNormal(vec3 normal) {
    // This could be
    // normf(vec3(normal.y - normal.z, -normal.x, normal.x))
    vec3 tangent = normf(cross(normal, vec3(0, 1, 1)));
    return tbnNormalTangent(normal, tangent);
}

float get_luminance(vec3 Color) {
    return 0.299 * Color.r + 0.587 * Color.g + 0.114 * Color.b;
}

float get_depth(vec2 ScreenPos, out bool IsDH) {
    float Depth = texture2D(depthtex0, ScreenPos).x;
    IsDH = false;
    #ifdef DISTANT_HORIZONS
    if (Depth >= 1) {
        Depth = texture2D(dhDepthTex, ScreenPos).x;
        IsDH = true;
    }
    #endif
    return Depth;
}

float get_depth_solid(vec2 ScreenPos, out bool IsDH) {
    float Depth = texture2D(depthtex1, ScreenPos).x;
    IsDH = false;
    #ifdef DISTANT_HORIZONS
    if (Depth >= 1) {
        Depth = texture2D(dhDepthTex1, ScreenPos).x;
        IsDH = true;
    }
    #endif
    return Depth;
}

vec2 rotate(vec2 P, float Ang) {
    float cosT = cos(Ang);
    float sinT = sin(Ang);
    return vec2(
        P.x * cosT - P.y * sinT,
        P.y * cosT + P.x * sinT
    );
}

