vec3 trace_godrays(vec3 ScreenPos, vec3 LightPos, vec3 LightColor, bool IsDH) {
    vec3 LightPosScreen = view_screen(LightPos, IsDH);

    float Dist = 1-pow(distance(LightPosScreen.xy, ScreenPos.xy), 0.3);
    if(Dist <= 0) return vec3(0);
    LightColor *= Dist;

    // Trace
    vec3 Offset = (ScreenPos-LightPosScreen)/GODRAYS_QUALITY;
    float Noise = dither(gl_FragCoord.xy);
    vec3 ExpectedPos = LightPosScreen+Offset*Noise;
    float LightFactor = 0;
    for(int i = 1; i <= GODRAYS_QUALITY; i++) {

        float RealDepth;
        if(isEyeInWater == 1) {
            RealDepth = get_depth_solid(ExpectedPos.xy, IsDH);
        }
        else {
            RealDepth = get_depth(ExpectedPos.xy, IsDH);
        }
        
        if(RealDepth == 1) {

            LightFactor++;
        }
        ExpectedPos += Offset;
    }
    const float SettingsFactor = 0.5/GODRAYS_QUALITY*GODRAYS_STRENGTH;
    return LightColor*LightFactor*SettingsFactor;
}

vec3 godrays(vec3 ScreenPos, bool IsDH) {
    vec3 FinalColor;
    if(sunPosition.z < 0) {
        const vec3 SUN_GLARE = to_linear(vec3(0.8, 0.45, 0.0));
        vec3 SunColor = (SUN_DIRECT*dayStrength/3+SUN_GLARE*(sunsetStrength+sunriseStrength));
        FinalColor = trace_godrays(ScreenPos, sunPosition, SunColor, IsDH);
    }
    else { // Moon
        vec3 MoonColor = (SUN_DIRECT*nightStrength/2);
        FinalColor = trace_godrays(ScreenPos, -sunPosition, MoonColor, IsDH);
    }
    FinalColor = tint_underwater(FinalColor);
    FinalColor *= 1-max(darknessFactor, blindness);
    return FinalColor;
}
