// Returns the bloom tile you are currently on
float is_in_range(vec2 texcoord) {
    vec2 Tile = floor(-log2(0.5-texcoord))+1;
    if(Tile.x != Tile.y) return 0.0;
    return Tile.x > BLOOM_SIZE+1 ? 0.0 : Tile.x;
}

float is_in_range(vec2 texcoord, out vec2 Bounds) {
    vec2 Tile = floor(-log2(0.5-texcoord))+1;
    if(Tile.x != Tile.y) return 0.0;
    if(Tile.x > BLOOM_SIZE+1) return 0.0;
    return Tile.x;
}

// https://github.com/Experience-Monks/glsl-fast-gaussian-blur
vec3 blur(sampler2D image, vec2 texcoord, vec2 direction) {
    vec3 color = vec3(0.0);
    vec2 off1 = vec2(1.3333333333333333) * direction / resolution;
    color += texture2D(image, texcoord).rgb * 0.29411764705882354;
    if(is_in_range(texcoord + off1) != 0)
        color += texture2D(image, texcoord + off1).rgb * 0.35294117647058826;
    if(is_in_range(texcoord - off1) != 0)
        color += texture2D(image, texcoord - off1).rgb * 0.35294117647058826;
    return color; 
}



