# What42's Shaders Base

![Example Image (Village)](/images/village.png)

### This is a base shaderpack that can be easily used to create your own shaders.

## Note: This is still somewhat early in development, so there are probably many features / fixes that I'm still working on

<br>

## Note: With the release of b1.9, OptiFine is now a second-class platform. It will still be supported, but my main focus will be Iris 1.19+

<br>
<br>

## Download on [Modrinth](https://modrinth.com/shader/what42s-shader-base)

<br>
<br>

## Effects:

- **Shadows**
- **Reflections** (water and rain puddles)
- **Extensive Styles System**
- **Colorblindness Correction**
- **Anti-Aliasing (TAA and FXAA)**
- **Isometric Rendering**
- **SSAO**
- **Sunrays** (depth-based and volumetric)
- **Depth of Field**
- **Pixelated Shadows**
- **Bloom**
- **Motion Blur**
- **Sharpening**
- **Waving blocks**
- **Fog**
- **Handheld light**
- **Post-Processing**
- - Underwater Waviness
- - Vignette
- - Tonemapping and Color Correction
- Many, many more

### Other Features:
- **Good Code Structuring**
- **Vanilla-Like Graphics and Style**
- **Distant Horizons Support**
- **Thorough Settings Menu** (200+ settings)

<br>
<br>

![Example Image (River)](/images/river.png)

<br>
<br>

## Credits:

- **[ShaderLabs](https://wiki.shaderlabs.org/wiki/Getting_Started):** Initial shaders base
- **[EminGTR](https://modrinth.com/shader/complementary-reimagined):** FXAA, TAA, coordinate transformation code, and code structure inspiration
- **[Acerola](https://github.com/GarrettGunnell/Minecraft-Shaders/blob/c1a6f5060dfd91ccac31e04fa529f2be4304a21a/shaders/final.fsh):** ACES tonemapping code
- **[Patricio Vivo](https://gist.github.com/patriciogonzalezvivo/670c22f3966e662d2f83):** Simplex noise function
- **[Nathan Reed](https://www.reedbeta.com/blog/hash-functions-for-gpu-rendering/):** Easy hashing function
- **[XorDev](https://github.com/XorDev/Ortho-Shaderpack/tree/master):** Original isometric projection code
