**About**

+ Solas is a modern fantasy stylized Minecraft: Java Edition shaderpack aiming to provide stunning visuals at a moderate performance cost. Please check the "Gallery" section to see some screenshots showcasing the shader's visual style and general look.

------------------------------------

**Unique Aspects**

+ Solas is one of the few Minecraft shaderpacks to achieve good performance with voxelized light propagation volume. Each light source has its unique color and can contribute to fog lighting depending on the scene, weather, dimension and other things.

+ Many shaderpacks with 3D volumetric clouds have a problem of them leaking into closed spaces like caves or mountains. Solas fixes that problem by toggling a cloud shadow check in cases when a closed space is detected, thus essentially turning volumetric clouds into volumetric light.

+ Another problem a lot of shaderpacks have is shadow light leaking and peter panning which is minimized in Solas.

------------------------------------

**Main Features**
+ Volumetric clouds, godrays, cloudy Nether & End fog.
+ Fancy underwater, atmospheric and border fog.
+ Water light absorption and refraction.
+ Fast multicolored block lighting.
+ Various sky effects: Aurora Borealis, Milky Way, Ender Nebula, Ender Black Hole and more.
+ Cinematic post effects: bloom, chromatic aberration, depth of field, distant blur, TAA, FXAA.
+ Integrated PBR resourcepack with autogenerated specular mapping, normals and emission.
+ Support for LabPBR and SeusPBR resourcepacks.
+ Advanced lighting effects: ambient occlusion, variable penumbra shadows and specular highlights.
+ Many customizable options with their proper translations to English, Russian, Chinese, French, Vietnamese and Spanish languages.
+ Experimental Distant Horizons support.

------------------------------------

**Important links**

+ **Boosty** (analogous to **Patreon**): [[Clickable]](https://boosty.to/septonious)
+ **Discord**: [[Clickable]](https://discord.gg/HEw9DbQwuM)
+ **GitHub**: [[Clickable]](https://github.com/Septonious/Solas-Shader)

------------------------------------

**Credits**

+ SixthSurge for VX LPV algorithm
+ EminGT and gri573 for improved shadow sampling
+ Capt Tatsu for TAA, FXAA and a few other pieces of BSL's code
+ Community members who have contributed to Solas in various ways
