/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes.support;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.unascribed.ears.api.EarsFeatureType;
import com.unascribed.ears.api.features.EarsFeatures;
import com.unascribed.ears.api.iface.EarsInhibitor;
import com.unascribed.ears.api.registry.EarsInhibitorRegistry;
import com.unascribed.ears.common.render.EarsRenderDelegate;
import dev.tr7zw.waveycapes.CapeRenderInfo;
import dev.tr7zw.waveycapes.CapeRenderer;
import dev.tr7zw.waveycapes.NMSUtil;
import dev.tr7zw.waveycapes.support.ModSupport;
import dev.tr7zw.waveycapes.util.NMSHelper;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class EarsSupport
implements ModSupport,
EarsInhibitor {
    private EarsRenderer render = new EarsRenderer();
    private WeakHashMap<Object, AtomicInteger> cache = new WeakHashMap();
    private ModelPart[] customCape = NMSUtil.buildCape(20, 16, x -> -1, y -> y - 1);

    public EarsSupport() {
        EarsInhibitorRegistry.register((String)"Waveycapes", (EarsInhibitor)this);
    }

    @Override
    public boolean shouldBeUsed(CapeRenderInfo capeRenderInfo) {
        EarsFeatures playerFeatures = EarsFeatures.getById((UUID)capeRenderInfo.getCapeHolder().getWCUUID());
        return playerFeatures != null && playerFeatures.capeEnabled;
    }

    @Override
    public CapeRenderer getRenderer() {
        return this.render;
    }

    private ResourceLocation getPlayerCape(CapeRenderInfo capeRenderInfo, EarsFeatures playerFeatures) {
        ResourceLocation skin = capeRenderInfo.getCapeTexture();
        return NMSHelper.getResourceLocation(skin.m_135827_(), EarsRenderDelegate.TexSource.CAPE.addSuffix(skin.m_135815_()));
    }

    @Override
    public boolean blockFeatureRenderer(Object feature) {
        return false;
    }

    public boolean shouldInhibit(EarsFeatureType arg0, Object arg1) {
        if (arg0 == EarsFeatureType.CAPE) {
            if (this.cache.containsKey(arg1)) {
                return true;
            }
            this.cache.put(arg1, null);
        }
        return false;
    }

    private class EarsRenderer
    implements CapeRenderer {
        private EarsRenderer() {
        }

        @Override
        public void render(CapeRenderInfo capeRenderInfo, int part, ModelPart model, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
            ResourceLocation cape;
            EarsFeatures playerFeatures = EarsFeatures.getById((UUID)capeRenderInfo.getCapeHolder().getWCUUID());
            VertexConsumer vertexConsumer = null;
            if (playerFeatures != null && playerFeatures.capeEnabled && (cape = EarsSupport.this.getPlayerCape(capeRenderInfo, playerFeatures)) != null) {
                vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)cape), (boolean)false, (boolean)false);
            }
            if (vertexConsumer == null) {
                vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)capeRenderInfo.getCapeTexture()), (boolean)false, (boolean)false);
            }
            EarsSupport.this.customCape[part].m_104301_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_);
        }

        @Override
        public boolean vanillaUvValues() {
            return false;
        }
    }
}

