/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.waveycapes.NMSUtil;
import dev.tr7zw.waveycapes.config.CustomConfigScreen;
import dev.tr7zw.waveycapes.delegate.PlayerDelegate;
import dev.tr7zw.waveycapes.support.AnimationSupport;
import dev.tr7zw.waveycapes.support.SupportManager;
import dev.tr7zw.waveycapes.util.NMSHelper;
import dev.tr7zw.waveycapes.versionless.CapeMovement;
import dev.tr7zw.waveycapes.versionless.CapeStyle;
import dev.tr7zw.waveycapes.versionless.ModBase;
import dev.tr7zw.waveycapes.versionless.WindMode;
import dev.tr7zw.waveycapes.versionless.config.Config;
import dev.tr7zw.waveycapes.versionless.nms.MinecraftPlayer;
import dev.tr7zw.waveycapes.versionless.util.Vector3;
import java.util.ArrayList;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class WaveyCapesBase
extends ModBase {
    public static WaveyCapesBase INSTANCE;

    @Override
    public void init() {
        INSTANCE = this;
        super.init();
        this.initSupportHooks();
    }

    @Override
    public Vector3 applyModAnimations(MinecraftPlayer player, Vector3 pos) {
        for (AnimationSupport sup : SupportManager.animationSupport) {
            pos = sup.applyAnimationChanges(((PlayerDelegate)player).getPlayer(), 0.0f, pos);
        }
        return pos;
    }

    public Screen createConfigScreen(Screen parent) {
        return new CustomConfigScreen(parent, "text.wc.title"){
            private int rotationX;
            private int rotationY;
            {
                this.rotationX = 164;
                this.rotationY = 5;
            }

            @Override
            public void initialize() {
                ArrayList<Object> options = new ArrayList<Object>();
                options.add(this.getEnumOption("text.wc.setting.capestyle", CapeStyle.class, () -> ModBase.config.capeStyle, v -> {
                    ModBase.config.capeStyle = v;
                }));
                options.add(this.getEnumOption("text.wc.setting.windmode", WindMode.class, () -> ModBase.config.windMode, v -> {
                    ModBase.config.windMode = v;
                }));
                options.add(this.getEnumOption("text.wc.setting.capemovement", CapeMovement.class, () -> ModBase.config.capeMovement, v -> {
                    ModBase.config.capeMovement = v;
                }));
                options.add(this.getIntOption("text.wc.setting.gravity", 5, 32, () -> ModBase.config.gravity, v -> {
                    ModBase.config.gravity = v;
                }));
                options.add(this.getIntOption("text.wc.setting.heightMultiplier", 4, 16, () -> ModBase.config.heightMultiplier, v -> {
                    ModBase.config.heightMultiplier = v;
                }));
                this.getOptions().m_232533_(options.toArray(new OptionInstance[0]));
            }

            @Override
            public void save() {
                WaveyCapesBase.this.writeConfig();
            }

            public boolean m_7933_(int i, int j, int k) {
                if (i == 263) {
                    --this.rotationX;
                }
                if (i == 262) {
                    ++this.rotationX;
                }
                if (i == 264) {
                    --this.rotationY;
                }
                if (i == 265) {
                    ++this.rotationY;
                }
                return super.m_7933_(i, j, k);
            }

            @Override
            public void m_88315_(GuiGraphics guiGraphics, int xMouse, int yMouse, float f) {
                super.m_88315_(guiGraphics, xMouse, yMouse, f);
                if (this.f_96541_.f_91073_ != null) {
                    int x = this.f_96541_.m_91268_().m_85445_() / 2;
                    int y = this.f_96541_.m_91268_().m_85446_() - this.f_96541_.m_91268_().m_85446_() / 3;
                    int size = (int)(40.0f * ((float)this.f_96541_.m_91268_().m_85446_() / 200.0f));
                    WaveyCapesBase.this.drawEntity(x, y, size, this.rotationX, this.rotationY, (LivingEntity)this.f_96541_.f_91074_, f);
                }
            }

            @Override
            public void reset() {
                ModBase.config = new Config();
                WaveyCapesBase.this.writeConfig();
            }
        };
    }

    private void drawEntity(int x, int y, int size, float lookX, float lookY, LivingEntity livingEntity, float delta) {
        float rotationModifyer = 3.0f;
        NMSUtil.prepareViewMatrix(x, y);
        PoseStack matrixStack = new PoseStack();
        matrixStack.m_85837_((double)x, (double)y, 1000.0);
        matrixStack.m_85841_((float)size, (float)size, (float)size);
        matrixStack.m_85841_(1.0f, 1.0f, -1.0f);
        Quaternionf quaternion = NMSHelper.ZP.m_252977_(180.0f);
        Quaternionf quaternion2 = NMSHelper.XP.m_252977_(lookY * rotationModifyer);
        quaternion.mul((Quaternionfc)quaternion2);
        matrixStack.m_252781_(quaternion);
        matrixStack.m_85837_(0.0, -1.0, 0.0);
        float yBodyRot = livingEntity.f_20883_;
        float yRot = NMSHelper.getYRot((Entity)livingEntity);
        float yRotO = livingEntity.f_19859_;
        float yBodyRotO = livingEntity.f_20884_;
        float xRot = NMSHelper.getXRot((Entity)livingEntity);
        float xRotO = livingEntity.f_19860_;
        float yHeadRotO = livingEntity.f_20886_;
        float yHeadRot = livingEntity.f_20885_;
        Vec3 vel = livingEntity.m_20184_();
        livingEntity.f_20883_ = 180.0f + lookX * rotationModifyer;
        NMSHelper.setYRot((Entity)livingEntity, 180.0f + lookX * rotationModifyer);
        livingEntity.f_20884_ = livingEntity.f_20883_;
        livingEntity.f_19859_ = NMSHelper.getYRot((Entity)livingEntity);
        livingEntity.m_20256_(Vec3.f_82478_);
        NMSHelper.setXRot((Entity)livingEntity, 0.0f);
        livingEntity.f_19860_ = NMSHelper.getXRot((Entity)livingEntity);
        livingEntity.f_20885_ = NMSHelper.getYRot((Entity)livingEntity);
        livingEntity.f_20886_ = NMSHelper.getYRot((Entity)livingEntity);
        NMSUtil.prepareLighting();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        NMSUtil.conjugate(quaternion2);
        entityRenderDispatcher.m_252923_(quaternion2);
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        entityRenderDispatcher.m_114384_((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, delta, matrixStack, (MultiBufferSource)bufferSource, 0xF000F0);
        bufferSource.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        livingEntity.f_20883_ = yBodyRot;
        livingEntity.f_20884_ = yBodyRotO;
        NMSHelper.setYRot((Entity)livingEntity, yRot);
        livingEntity.f_19859_ = yRotO;
        NMSHelper.setXRot((Entity)livingEntity, xRot);
        livingEntity.f_19860_ = xRotO;
        livingEntity.f_20886_ = yHeadRotO;
        livingEntity.f_20885_ = yHeadRot;
        livingEntity.m_20256_(vel);
        NMSUtil.resetViewMatrix();
        Lighting.m_84931_();
    }

    @Override
    public void initSupportHooks() {
    }

    @Generated
    public static WaveyCapesBase getINSTANCE() {
        return INSTANCE;
    }
}

