/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.waiter.media;

import org.watermedia.videolan4j.media.Media;
import org.watermedia.videolan4j.media.MediaEventAdapter;
import org.watermedia.videolan4j.media.MediaEventListener;
import org.watermedia.videolan4j.media.MediaParsedStatus;
import org.watermedia.videolan4j.media.MediaRef;
import org.watermedia.videolan4j.media.Meta;
import org.watermedia.videolan4j.media.Picture;
import org.watermedia.videolan4j.player.base.State;
import org.watermedia.videolan4j.waiter.Waiter;

public abstract class MediaWaiter<R>
extends Waiter<Media, R>
implements MediaEventListener {
    private final MediaEventListener internalListener = new InternalListener();

    protected MediaWaiter(Media component) {
        super(component);
    }

    @Override
    protected final void startListening(Media component) {
        component.events().addMediaEventListener(this.internalListener);
        component.events().addMediaEventListener(this);
    }

    @Override
    protected final void stopListening(Media component) {
        component.events().removeMediaEventListener(this.internalListener);
        component.events().removeMediaEventListener(this);
    }

    @Override
    public void mediaMetaChanged(Media media, Meta metaType) {
    }

    @Override
    public void mediaSubItemAdded(Media media, MediaRef newChild) {
    }

    @Override
    public void mediaDurationChanged(Media media, long newDuration) {
    }

    @Override
    public void mediaParsedChanged(Media media, MediaParsedStatus newStatus) {
    }

    @Override
    public void mediaFreed(Media media, MediaRef mediaFreed) {
    }

    @Override
    public void mediaStateChanged(Media media, State newState) {
    }

    @Override
    public void mediaSubItemTreeAdded(Media media, MediaRef item) {
    }

    @Override
    public void mediaThumbnailGenerated(Media media, Picture picture) {
    }

    private class InternalListener
    extends MediaEventAdapter {
        private InternalListener() {
        }

        @Override
        public void mediaStateChanged(Media media, State newState) {
            switch (newState) {
                case ENDED: {
                    MediaWaiter.super.finished();
                    break;
                }
                case ERROR: {
                    MediaWaiter.super.error();
                }
            }
        }
    }
}

