/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.player.embedded.videosurface;

import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import org.watermedia.videolan4j.ByteBufferFactory;
import org.watermedia.videolan4j.VideoLan4J;
import org.watermedia.videolan4j.binding.lib.Kernel32;
import org.watermedia.videolan4j.binding.lib.LibC;
import org.watermedia.videolan4j.binding.lib.size_t;
import org.watermedia.videolan4j.player.embedded.videosurface.callback.BufferFormat;

final class NativeBuffers {
    private final boolean lockBuffers;
    private ByteBuffer[] nativeBuffers;
    private Pointer[] pointers;

    public NativeBuffers(boolean lockBuffers) {
        this.lockBuffers = lockBuffers;
    }

    int allocate(BufferFormat bufferFormat) {
        int planeCount = bufferFormat.getPlaneCount();
        int[] pitchValues = bufferFormat.getPitches();
        int[] lineValues = bufferFormat.getLines();
        this.nativeBuffers = new ByteBuffer[planeCount];
        this.pointers = new Pointer[planeCount];
        for (int i = 0; i < planeCount; ++i) {
            ByteBuffer buffer = ByteBufferFactory.alloc(pitchValues[i] * lineValues[i]);
            if (!ByteBufferFactory.isAligned(ByteBufferFactory.address(buffer))) {
                VideoLan4J.LOGGER.warn("Detected an unaligned buffer. this might lead in I/O issues");
            }
            this.nativeBuffers[i] = buffer;
            this.pointers[i] = Pointer.createConstant((long)ByteBufferFactory.address(buffer));
            if (!this.lockBuffers) continue;
            if (!Platform.isWindows()) {
                LibC.INSTANCE.mlock(this.pointers[i], new NativeLong((long)buffer.capacity()));
                continue;
            }
            Kernel32.INSTANCE.VirtualLock(this.pointers[i], new size_t(buffer.capacity()));
        }
        return this.nativeBuffers.length;
    }

    void free() {
        if (this.nativeBuffers != null) {
            if (this.lockBuffers) {
                for (int i = 0; i < this.nativeBuffers.length; ++i) {
                    if (!Platform.isWindows()) {
                        LibC.INSTANCE.munlock(this.pointers[i], new NativeLong((long)this.nativeBuffers[i].capacity()));
                        continue;
                    }
                    Kernel32.INSTANCE.VirtualUnlock(this.pointers[i], new size_t(this.nativeBuffers[i].capacity()));
                }
            }
            for (ByteBuffer buffer : this.nativeBuffers) {
                ByteBufferFactory.dealloc(buffer);
            }
            this.nativeBuffers = null;
            this.pointers = null;
        }
    }

    ByteBuffer[] buffers() {
        return this.nativeBuffers;
    }

    Pointer[] pointers() {
        return this.pointers;
    }
}

