/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.media;

import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.media.BaseApi;
import org.watermedia.videolan4j.media.Media;
import org.watermedia.videolan4j.media.MediaParsedStatus;
import org.watermedia.videolan4j.media.ParseFlag;

public final class ParseApi
extends BaseApi {
    ParseApi(Media media) {
        super(media);
    }

    public boolean parse() {
        return this.parse(-1, (ParseFlag[])null);
    }

    public boolean parse(int timeout) {
        return this.parse(timeout, (ParseFlag[])null);
    }

    public boolean parse(ParseFlag ... flags) {
        return this.parse(-1, flags);
    }

    public boolean parse(int timeout, ParseFlag ... flags) {
        return LibVlc.libvlc_media_parse_with_options(this.mediaInstance, this.flagsToInt(flags), timeout) == 0;
    }

    public void stop() {
        LibVlc.libvlc_media_parse_stop(this.mediaInstance);
    }

    public MediaParsedStatus status() {
        return MediaParsedStatus.mediaParsedStatus(LibVlc.libvlc_media_get_parsed_status(this.mediaInstance));
    }

    private int flagsToInt(ParseFlag ... flags) {
        int result = 0;
        if (flags != null) {
            for (ParseFlag flag : flags) {
                result |= flag.intValue();
            }
        }
        return result;
    }
}

