/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.Consumer;
import java.util.function.Function;
import sun.misc.Unsafe;

public class ByteBufferFactory {
    private static final Unsafe UNSAFE;
    private static final long ADDRESS_FIELD_OFFSET;
    static Function<Integer, ByteBuffer> BUFFER_ALLOCATOR;
    static Consumer<ByteBuffer> BUFFER_DEALLOCATOR;

    public static ByteBuffer alloc(int size) {
        return BUFFER_ALLOCATOR.apply(size);
    }

    public static void dealloc(ByteBuffer buffer) {
        BUFFER_DEALLOCATOR.accept(buffer);
    }

    static void dealloc1(ByteBuffer buffer) {
    }

    static ByteBuffer alloc1(int size) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(size + 32);
        long address = ByteBufferFactory.address((Buffer)buffer);
        if (!ByteBufferFactory.isAligned(address)) {
            int newPosition = (int)(32L - (address & 0x1FL));
            ((Buffer)buffer).position(newPosition);
            size += newPosition;
        }
        ByteBuffer result = (ByteBuffer)((Buffer)buffer).limit(size);
        return result.slice().order(ByteOrder.nativeOrder());
    }

    public static long address(ByteBuffer buffer) {
        return UNSAFE.getLong(buffer, ADDRESS_FIELD_OFFSET);
    }

    public static boolean isAligned(long address) {
        return (address & 0x1FL) == 0L;
    }

    public static long address(Buffer buffer) {
        return UNSAFE.getLong(buffer, ADDRESS_FIELD_OFFSET);
    }

    static {
        BUFFER_ALLOCATOR = ByteBufferFactory::alloc1;
        BUFFER_DEALLOCATOR = ByteBufferFactory::dealloc1;
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            UNSAFE = (Unsafe)field.get(null);
            ADDRESS_FIELD_OFFSET = UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

