/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.kiulian.downloader.model.subtitles;

import org.watermedia.shaded.kiulian.downloader.model.Extension;

public class Subtitles {
    private final String url;
    private final boolean fromCaptions;
    private Extension format;
    private String translationLanguage;

    Subtitles(String url, boolean fromCaptions) {
        this.url = url;
        this.fromCaptions = fromCaptions;
    }

    public Subtitles formatTo(Extension extension) {
        this.format = extension;
        return this;
    }

    public Subtitles translateTo(String language) {
        if (this.fromCaptions) {
            this.translationLanguage = language;
        }
        return this;
    }

    public String getDownloadUrl() {
        String downloadUrl = this.url;
        if (this.format != null && this.format.isSubtitle()) {
            downloadUrl = downloadUrl + "&fmt=" + this.format.value();
        }
        if (this.translationLanguage != null && !this.translationLanguage.isEmpty()) {
            downloadUrl = downloadUrl + "&tlang=" + this.translationLanguage;
        }
        return downloadUrl;
    }
}

