/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.loaders;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Supplier;
import jdk.internal.loader.ClassLoaders;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.WaterMedia;
import org.watermedia.core.exceptions.IllegalEnvironmentException;
import org.watermedia.core.exceptions.IllegalTLauncherException;
import org.watermedia.core.exceptions.IncompatibleModException;
import org.watermedia.core.tools.Tool;
import org.watermedia.loaders.ILoader;

@Mod(value="watermedia")
public class ForgeLoader
implements ILoader {
    private static final Marker IT = MarkerManager.getMarker((String)"ForgeLoader");
    private static final Path tmpPath = new File(System.getProperty("java.io.tmpdir")).toPath().toAbsolutePath().resolve("watermedia");
    private static final Path processPath = new File("").toPath().toAbsolutePath();

    public ForgeLoader() {
        try {
            String pairClassName = this.concatPackage("org", "apache", "commons", "lang3", "tuple", "Pair");
            Method pairOf = Class.forName(pairClassName).getMethod("of", Object.class, Object.class);
            Supplier<String> stringSupplier = () -> "";
            Supplier<Boolean> booleanSupplier = () -> true;
            Object o = pairOf.invoke(null, stringSupplier, booleanSupplier);
            ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> o);
            WaterMedia.LOGGER.info(IT, "DISPLAYTEST correctly updated");
        }
        catch (Throwable pairClassName) {
            // empty catch block
        }
        try {
            if (this.tlcheck()) {
                throw new IllegalTLauncherException();
            }
            if (this.modInstalled("xenon")) {
                throw new IncompatibleModException("xenon", "Xenon", "Embeddium (embeddium) or Sodium (sodium)");
            }
            if (this.clientSide()) {
                WaterMedia.prepare(this).start();
            } else if (!this.developerMode()) {
                throw new IllegalEnvironmentException();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed starting WATERMeDIA for " + this.name() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public String name() {
        return "Forge";
    }

    @Override
    public Path tempDir() {
        return tmpPath;
    }

    @Override
    public Path processDir() {
        return processPath;
    }

    @Override
    public boolean tlcheck() {
        boolean isT = Tool.t() || this.modInstalled("tlskincape") || this.modInstalled("tlauncher_custom_cape_skin");
        try {
            Class<?> launcher;
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            if (!isT) {
                launcher = Class.forName("cpw.mods.modlauncher.Launcher");
                Thread.currentThread().setContextClassLoader(launcher.getClassLoader());
                isT = Tool.t();
                Thread.currentThread().setContextClassLoader(current);
            }
            if (!isT) {
                launcher = Class.forName("net.minecraftforge.modlauncher.Launcher");
                Thread.currentThread().setContextClassLoader(launcher.getClassLoader());
                isT = Tool.t();
                Thread.currentThread().setContextClassLoader(current);
            }
            if (!isT) {
                launcher = Class.forName("cpw.mods.bootstraplauncher.BootstrapLauncher");
                Thread.currentThread().setContextClassLoader(launcher.getClassLoader());
                isT = Tool.t();
                Thread.currentThread().setContextClassLoader(current);
            }
            if (!isT) {
                launcher = Class.forName("net.minecraftforge.bootstraplauncher.BootstrapLauncher");
                Thread.currentThread().setContextClassLoader(launcher.getClassLoader());
                isT = Tool.t();
                Thread.currentThread().setContextClassLoader(current);
            }
            try {
                if (!isT) {
                    Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                    isT = Tool.t();
                    Thread.currentThread().setContextClassLoader(current);
                }
                if (!isT) {
                    Thread.currentThread().setContextClassLoader(ClassLoaders.appClassLoader());
                    isT = Tool.t();
                    Thread.currentThread().setContextClassLoader(current);
                }
            }
            catch (Throwable launcher2) {
                // empty catch block
            }
            if (!isT) {
                Collection<StackTraceElement[]> traceElements = Thread.getAllStackTraces().values();
                block4: for (StackTraceElement[] elements : traceElements) {
                    for (StackTraceElement e : elements) {
                        if (!e.getClassName().startsWith("org.tlauncher")) continue;
                        isT = true;
                        continue block4;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isT;
    }

    public boolean modInstalled(String id) {
        return FMLLoader.getLoadingModList().getModFileById(id) != null;
    }

    @Override
    public boolean clientSide() {
        try {
            return FMLLoader.getDist().isClient();
        }
        catch (Throwable t2) {
            WaterMedia.LOGGER.error(IT, "Cannot check if was client, assuming it was");
            return true;
        }
    }

    @Override
    public boolean developerMode() {
        try {
            return !FMLLoader.isProduction();
        }
        catch (Throwable t) {
            WaterMedia.LOGGER.error(IT, "Cannot check if was developer env, assuming it wasn't");
            return false;
        }
    }

    private String concatPackage(String ... pgk) {
        StringBuilder r = new StringBuilder();
        for (String s : pgk) {
            r.append(s).append(".");
        }
        if (r.length() > 0) {
            r.setLength(r.length() - 1);
        }
        return r.toString();
    }
}

