/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.core.tools;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.WaterMedia;

public class PidTool {
    private static final Marker IT = MarkerManager.getMarker((String)"Tools");
    private static final Pattern PID_PATTERN = Pattern.compile("^(.+?)\\s+(\\d+)\\s+(\\S+)\\s+(\\d+)\\s+([\\d,]+\\s+\\S+)$");

    public static List<ProcessData> getWindowsPids() {
        ProcessBuilder builder = new ProcessBuilder("cmd.exe", "/c", "tasklist");
        builder.redirectErrorStream(true);
        try {
            Process p = builder.start();
            ArrayList<ProcessData> process = new ArrayList<ProcessData>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String line;
                int i = 0;
                while ((line = reader.readLine()) != null) {
                    Matcher matcher;
                    if (i++ <= 1 || !(matcher = PID_PATTERN.matcher(line)).matches()) continue;
                    process.add(new ProcessData(matcher.group(1).trim(), Integer.parseInt(matcher.group(2)), matcher.group(3), Integer.parseInt(matcher.group(4)), matcher.group(5).trim()));
                }
            }
            int exitCode = p.waitFor();
            WaterMedia.LOGGER.debug(IT, "All PIDs collected, finished with status code {}", (Object)exitCode);
            return process;
        }
        catch (Exception e) {
            return new ArrayList<ProcessData>();
        }
    }

    public static class ProcessData {
        private final String pidName;
        private final int pid;
        private final String sessionName;
        private final int sid;
        private final String mem;

        public ProcessData(String pidName, int pid, String sessionName, int sid, String mem) {
            this.pidName = pidName;
            this.pid = pid;
            this.sessionName = sessionName;
            this.sid = sid;
            this.mem = mem;
        }

        public String toString() {
            return "ProcessData{pidName='" + this.pidName + '\'' + ", pid=" + this.pid + ", sessionName='" + this.sessionName + '\'' + ", sid=" + this.sid + ", mem='" + this.mem + '\'' + '}';
        }
    }
}

