/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.network.patchs.onedrive;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import org.watermedia.api.network.patchs.onedrive.OneDriveItem;

public class OneDriveUtil {
    private static final String API_URL = "https://api.onedrive.com/v1.0/";

    public static OneDriveItem getDownloableItem(String sharedUrl) throws IOException {
        String url = OneDriveUtil.formatURL(sharedUrl);
        return OneDriveUtil.getItem(url);
    }

    private static String formatURL(String sharedUrl) {
        String base64 = Base64.getUrlEncoder().withoutPadding().encodeToString(sharedUrl.getBytes());
        String encodedUrl = "u!" + base64;
        return "https://api.onedrive.com/v1.0/shares/" + encodedUrl + "/driveItem";
    }

    private static OneDriveItem getItem(String url) throws IOException {
        URL itemURL = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)itemURL.openConnection();
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed to get item: " + connection.getResponseMessage());
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        Gson gson = new Gson();
        return (OneDriveItem)gson.fromJson((Reader)reader, OneDriveItem.class);
    }
}

