/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.network.patchs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.WaterMedia;
import org.watermedia.api.network.patchs.AbstractPatch;
import org.watermedia.api.network.patchs.twitch.StreamQuality;
import org.watermedia.core.tools.NetTool;
import org.watermedia.shaded.kiulian.downloader.YoutubeDownloader;
import org.watermedia.shaded.kiulian.downloader.downloader.client.Client;
import org.watermedia.shaded.kiulian.downloader.downloader.client.DefaultClients;
import org.watermedia.shaded.kiulian.downloader.downloader.request.RequestVideoInfo;
import org.watermedia.shaded.kiulian.downloader.downloader.response.Response;
import org.watermedia.shaded.kiulian.downloader.model.videos.VideoDetails;
import org.watermedia.shaded.kiulian.downloader.model.videos.VideoInfo;
import org.watermedia.shaded.kiulian.downloader.model.videos.formats.AudioFormat;
import org.watermedia.shaded.kiulian.downloader.model.videos.formats.VideoFormat;

public class YoutubePatch
extends AbstractPatch {
    private static final Marker IT = MarkerManager.getMarker((String)"YoutubePatch");
    private static final YoutubeDownloader DOWNLOADER = new YoutubeDownloader();
    private static final Pattern PATTERN = Pattern.compile("(?:youtu\\.be/|youtube\\.com/(?:embed/|v/|shorts/|feeds/api/videos/|watch\\?v=|watch\\?.+&v=))([^/?&#]+)");
    private static Client WORKING_CLIENT;
    private static boolean WORKING_TESTED;
    private static final ReentrantLock LOCK;

    @Override
    public String platform() {
        return "Youtube";
    }

    @Override
    public boolean isValid(URI uri) {
        return uri.getHost() != null && PATTERN.matcher(uri.toString()).find();
    }

    @Override
    public AbstractPatch.Result patch(URI uri, AbstractPatch.Quality preferQuality) throws AbstractPatch.FixingURLException {
        super.patch(uri, preferQuality);
        if (WORKING_TESTED && WORKING_CLIENT == null) {
            throw new AbstractPatch.FixingURLException(uri, (Throwable)new UnsupportedOperationException("Youtube cannot be accessed at this moment"));
        }
        Matcher matcher = PATTERN.matcher(uri.toString());
        if (matcher.find()) {
            try {
                VideoFormat bestVideo;
                VideoFormat bestAll;
                VideoDetails videoDetails;
                int client = 0;
                VideoInfo videoInfo = null;
                Response<VideoInfo> response = null;
                String videoId = matcher.group(1);
                if (!WORKING_TESTED) {
                    if (LOCK.isLocked()) {
                        WaterMedia.LOGGER.warn(IT, "Waiting patch for {}, another thread is searching for a working client", (Object)uri);
                    }
                    LOCK.lock();
                }
                do {
                    Client c = WORKING_TESTED ? WORKING_CLIENT : DefaultClients.VALUES[client];
                    RequestVideoInfo request = (RequestVideoInfo)new RequestVideoInfo(videoId).client(c);
                    response = DOWNLOADER.getVideoInfo(request);
                    videoInfo = response.data();
                    if (!WORKING_TESTED) {
                        WaterMedia.LOGGER.debug(IT, "Testing '{}'", (Object)c.getName());
                    }
                    if (videoInfo == null) continue;
                    HttpURLConnection conn = NetTool.connectToHTTP(URI.create(response.data().bestVideoFormat().url()), "GET");
                    if (conn.getResponseCode() != 403) {
                        conn.disconnect();
                        continue;
                    }
                    videoInfo = null;
                } while (!WORKING_TESTED && videoInfo == null && ++client < DefaultClients.VALUES.length);
                if (!WORKING_TESTED) {
                    LOCK.unlock();
                }
                if (videoInfo == null) {
                    WORKING_TESTED = true;
                    throw new RuntimeException("Cannot fetch video info", response.error());
                }
                if (!WORKING_TESTED) {
                    WORKING_TESTED = true;
                    WaterMedia.LOGGER.info(IT, "Found working Youtube client '{}'", (Object)DefaultClients.VALUES[client].getName());
                }
                if (WORKING_CLIENT == null) {
                    WORKING_CLIENT = DefaultClients.VALUES[client];
                }
                if ((videoDetails = videoInfo.details()).isLive()) {
                    String ytLivePlaylist = this.fetchLivePlaylist(videoDetails.liveUrl());
                    if (ytLivePlaylist != null) {
                        return new AbstractPatch.Result(new URI(StreamQuality.parse(ytLivePlaylist).get(0).getUrl()), true, true);
                    }
                } else if (WaterMedia.YES_SLAVISM.getAsBoolean()) {
                    bestAll = videoInfo.bestVideoWithAudioFormat();
                    bestVideo = videoInfo.bestVideoFormat();
                    AudioFormat bestAudio = videoInfo.bestAudioFormat();
                    if (bestVideo != null) {
                        AbstractPatch.Result r = new AbstractPatch.Result(new URI(bestVideo.url()), true, false);
                        if (bestVideo != bestAll) {
                            r.setAudioTrack(new URI(bestAudio.url()));
                        }
                        return r;
                    }
                    if (bestAudio != null) {
                        return new AbstractPatch.Result(new URI(bestAudio.url()), true, false);
                    }
                } else {
                    bestAll = videoInfo.bestVideoWithAudioFormat();
                    if (bestAll != null) {
                        return new AbstractPatch.Result(new URI(bestAll.url()), true, false);
                    }
                    bestVideo = videoInfo.bestVideoFormat();
                    if (bestVideo != null) {
                        return new AbstractPatch.Result(new URI(bestVideo.url()), true, false);
                    }
                    AudioFormat bestAudio = videoInfo.bestAudioFormat();
                    if (bestAudio != null) {
                        return new AbstractPatch.Result(new URI(bestAudio.url()), true, false);
                    }
                }
                return null;
            }
            catch (Exception e) {
                throw new AbstractPatch.FixingURLException(uri.toString(), (Throwable)e);
            }
        }
        return null;
    }

    private String fetchLivePlaylist(String url) throws IOException {
        int length;
        URL apiUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)apiUrl.openConnection();
        conn.setRequestMethod("GET");
        int responseCode = conn.getResponseCode();
        if (responseCode != 200) {
            return null;
        }
        InputStream inputStream = conn.getInputStream();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }

    static {
        LOCK = new ReentrantLock();
    }
}

