/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.client.display;

import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.client.display.Display;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.watermedia.WaterMedia;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="waterframes", bus=Mod.EventBusSubscriber.Bus.FORGE)
@OnlyIn(value=Dist.CLIENT)
public class DisplayList {
    public static final Integer DEFAULT_SIZE = 32;
    private static volatile Display[] displays = new Display[DEFAULT_SIZE.intValue()];
    private static int position = 0;
    private static boolean checkSize = false;
    private static boolean paused;

    public static void add(Display display) {
        Display[] freshMeal;
        if (checkSize) {
            if ((float)position / (float)displays.length <= 0.25f) {
                freshMeal = new Display[displays.length / 2];
                System.arraycopy(displays, 0, freshMeal, 0, position);
                displays = freshMeal;
            }
            checkSize = false;
        }
        if (position >= displays.length) {
            freshMeal = new Display[displays.length * 2];
            position = DisplayList.copyData$resetPosition(displays, freshMeal);
            displays = freshMeal;
            checkSize = true;
        }
        if (paused) {
            display.setPauseMode(true);
        }
        DisplayList.displays[DisplayList.position++] = display;
    }

    public static void pause() {
        paused = true;
        for (int i = 0; i < position; ++i) {
            if (displays[i] == null) continue;
            displays[i].setPauseMode(true);
        }
    }

    public static void resume() {
        paused = false;
        for (int i = 0; i < position; ++i) {
            if (displays[i] == null) continue;
            displays[i].setPauseMode(false);
        }
    }

    public static void remove(int i) {
        if (i > displays.length) {
            return;
        }
        DisplayList.displays[i] = null;
    }

    public static void remove(Display obj) {
        if (obj == null) {
            return;
        }
        for (int i = 0; i < position; ++i) {
            if (obj != displays[i]) continue;
            DisplayList.displays[i] = null;
            break;
        }
    }

    public static void release() {
        for (int i = 0; i < position; ++i) {
            if (displays[i] == null) continue;
            displays[i].release();
            DisplayList.displays[i] = null;
        }
        displays = new Display[DEFAULT_SIZE.intValue()];
        position = 0;
    }

    private static int copyData$resetPosition(Display[] current, Display[] target) {
        int freshPosition = 0;
        for (int i = 0; i < current.length; ++i) {
            if (current[i] == null) continue;
            target[freshPosition++] = current[i];
            current[i] = null;
        }
        return freshPosition;
    }

    @SubscribeEvent
    public static void onUnloadingLevel(LevelEvent.Unload event) {
        LevelAccessor level = event.getLevel();
        if (level != null && level.m_5776_()) {
            DisplayList.release();
        }
    }

    @SubscribeEvent
    public static void onLoadingLevel(LevelEvent.Load event) {
        if (event.getLevel() != null && event.getLevel().m_5776_()) {
            WaterMedia.setSlavismMode((boolean)DisplaysConfig.useSlavismMode());
        }
    }

    public static void onClientPause(boolean paused) {
        if (paused) {
            DisplayList.pause();
        }
    }
}

