/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init.custom;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.init.TFStructures;
import twilightforest.init.custom.Enforcement;
import twilightforest.util.PlayerHelper;
import twilightforest.util.Restriction;

public class Restrictions {
    public static final ResourceKey<Registry<Restriction>> RESTRICTION_KEY = ResourceKey.m_135788_((ResourceLocation)TwilightForestMod.namedRegistry("restrictions"));
    public static final DeferredRegister<Restriction> RESTRICTIONS = DeferredRegister.create(RESTRICTION_KEY, (String)"twilightforest");
    public static final Codec<Holder<Restriction>> CODEC = RegistryFileCodec.m_135592_(RESTRICTION_KEY, Restriction.CODEC, (boolean)false);
    public static final ResourceKey<Restriction> DARK_FOREST = Restrictions.makeKey(TFBiomes.DARK_FOREST.m_135782_());
    public static final ResourceKey<Restriction> DARK_FOREST_CENTER = Restrictions.makeKey(TFBiomes.DARK_FOREST_CENTER.m_135782_());
    public static final ResourceKey<Restriction> FINAL_PLATEAU = Restrictions.makeKey(TFBiomes.FINAL_PLATEAU.m_135782_());
    public static final ResourceKey<Restriction> FIRE_SWAMP = Restrictions.makeKey(TFBiomes.FIRE_SWAMP.m_135782_());
    public static final ResourceKey<Restriction> GLACIER = Restrictions.makeKey(TFBiomes.GLACIER.m_135782_());
    public static final ResourceKey<Restriction> HIGHLANDS = Restrictions.makeKey(TFBiomes.HIGHLANDS.m_135782_());
    public static final ResourceKey<Restriction> SNOWY_FOREST = Restrictions.makeKey(TFBiomes.SNOWY_FOREST.m_135782_());
    public static final ResourceKey<Restriction> SWAMP = Restrictions.makeKey(TFBiomes.SWAMP.m_135782_());
    public static final ResourceKey<Restriction> THORNLANDS = Restrictions.makeKey(TFBiomes.THORNLANDS.m_135782_());

    private static ResourceKey<Restriction> makeKey(ResourceLocation name) {
        return ResourceKey.m_135785_(RESTRICTION_KEY, (ResourceLocation)name);
    }

    public static void bootstrap(BootstapContext<Restriction> context) {
        context.m_255272_(DARK_FOREST, (Object)new Restriction(TFStructures.KNIGHT_STRONGHOLD, (ResourceKey<Enforcement>)Enforcement.DARKNESS.getKey(), 0.0f, Restrictions.asStack(TFBlocks.LICH_TOWER_MINIATURE_STRUCTURE), List.of(TwilightForestMod.prefix("progress_lich"))));
        context.m_255272_(DARK_FOREST_CENTER, (Object)new Restriction(TFStructures.DARK_TOWER, (ResourceKey<Enforcement>)Enforcement.DARKNESS.getKey(), 0.0f, Restrictions.asStack(TFBlocks.KNIGHT_PHANTOM_TROPHY), List.of(TwilightForestMod.prefix("progress_knights"))));
        context.m_255272_(FINAL_PLATEAU, (Object)new Restriction(TFStructures.FINAL_CASTLE, (ResourceKey<Enforcement>)Enforcement.ACID_RAIN.getKey(), 1.5f, Restrictions.asStack(TFItems.LAMP_OF_CINDERS), List.of(TwilightForestMod.prefix("progress_troll"))));
        context.m_255272_(FIRE_SWAMP, (Object)new Restriction(TFStructures.HYDRA_LAIR, (ResourceKey<Enforcement>)Enforcement.FIRE.getKey(), 8.0f, Restrictions.asStack(TFItems.MEEF_STROGANOFF), List.of(TwilightForestMod.prefix("progress_labyrinth"))));
        context.m_255272_(GLACIER, (Object)new Restriction(TFStructures.AURORA_PALACE, (ResourceKey<Enforcement>)Enforcement.FROST.getKey(), 3.0f, Restrictions.asStack(TFItems.ALPHA_YETI_FUR), List.of(TwilightForestMod.prefix("progress_yeti"))));
        context.m_255272_(HIGHLANDS, (Object)new Restriction(TFStructures.TROLL_CAVE, (ResourceKey<Enforcement>)Enforcement.ACID_RAIN.getKey(), 0.5f, Restrictions.asStack(TFBlocks.UBEROUS_SOIL), List.of(TwilightForestMod.prefix("progress_merge"))));
        context.m_255272_(SNOWY_FOREST, (Object)new Restriction(TFStructures.YETI_CAVE, (ResourceKey<Enforcement>)Enforcement.FROST.getKey(), 2.0f, Restrictions.asStack(TFBlocks.LICH_TOWER_MINIATURE_STRUCTURE), List.of(TwilightForestMod.prefix("progress_lich"))));
        context.m_255272_(SWAMP, (Object)new Restriction(TFStructures.LABYRINTH, (ResourceKey<Enforcement>)Enforcement.HUNGER.getKey(), 1.0f, Restrictions.asStack(TFBlocks.LICH_TOWER_MINIATURE_STRUCTURE), List.of(TwilightForestMod.prefix("progress_lich"))));
        context.m_255272_(THORNLANDS, (Object)new Restriction(TFStructures.FINAL_CASTLE, (ResourceKey<Enforcement>)Enforcement.ACID_RAIN.getKey(), 1.0f, Restrictions.asStack(TFItems.LAMP_OF_CINDERS), List.of(TwilightForestMod.prefix("progress_troll"))));
    }

    public static ItemStack asStack(RegistryObject<?> item) {
        ItemLike itemLike;
        Object object = item.get();
        return Restrictions.asStack(object instanceof ItemLike ? (itemLike = (ItemLike)object) : (ItemLike)TFBlocks.TWILIGHT_PORTAL_MINIATURE_STRUCTURE.get());
    }

    public static ItemStack asStack(ItemLike itemLike) {
        return new ItemStack(itemLike);
    }

    public static Optional<Restriction> getRestrictionForBiome(Biome biome, Entity entity) {
        if (entity instanceof Player) {
            Restriction restrictions;
            Player player = (Player)entity;
            RegistryAccess access = entity.m_9236_().m_9598_();
            ResourceLocation biomeLocation = access.m_175515_(Registries.f_256952_).m_7981_((Object)biome);
            if (biomeLocation != null && (restrictions = (Restriction)access.m_175515_(RESTRICTION_KEY).m_7745_(biomeLocation)) != null && !PlayerHelper.doesPlayerHaveRequiredAdvancements(player, restrictions.advancements())) {
                return Optional.of(restrictions);
            }
        }
        return Optional.empty();
    }

    public static boolean isBiomeSafeFor(Biome biome, Entity entity) {
        return Restrictions.getRestrictionForBiome(biome, entity).isEmpty();
    }
}

