/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LightLayer;

public class FireflyParticle
extends TextureSheetParticle {
    private final int halfLife;
    private final boolean checkSkylight;

    public FireflyParticle(ClientLevel level, double x, double y, double z, float movementX, float movementY, float movementZ, int minlife, boolean checkSkylight) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.f_107215_ *= (double)movementX;
        this.f_107216_ *= (double)movementY;
        this.f_107217_ *= (double)movementZ;
        this.f_107227_ = 0.5f + this.f_107223_.m_188501_() * 0.25f;
        this.f_107228_ = 0.85f - this.f_107223_.m_188501_() * 0.25f;
        this.f_107229_ = 0.0f;
        this.f_107663_ = 0.2f + this.f_107223_.m_188501_() * 0.1f;
        this.f_107225_ = minlife + this.f_107223_.m_188503_(21);
        this.halfLife = this.f_107225_ / 2;
        this.f_107219_ = true;
        this.checkSkylight = checkSkylight;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialTicks) {
        this.f_107230_ = this.getGlowBrightness();
        super.m_5744_(buffer, camera, partialTicks);
    }

    public void m_5989_() {
        if (this.checkSkylight && this.f_107208_.m_45517_(LightLayer.SKY, BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_)) < 1) {
            this.m_107274_();
        }
        super.m_5989_();
    }

    public float getGlowBrightness() {
        int lifeTime = this.f_107225_ - this.f_107224_;
        if (lifeTime <= this.halfLife) {
            return (float)lifeTime / (float)this.halfLife;
        }
        return Math.max(1.0f - ((float)lifeTime - (float)this.halfLife) / (float)this.halfLife, 0.0f);
    }

    public int m_6355_(float partialTicks) {
        return 0xF000F0;
    }

    public record ParticleSpawnerProvider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FireflyParticle particle = new FireflyParticle(level, x, y, z, 0.1f, 0.1f, 0.1f, 30, false);
            RandomSource rand = level.m_213780_();
            particle.f_107215_ += (double)rand.m_188501_() * (rand.m_188499_() ? -3.9 : 3.9) * (double)rand.m_188501_() * 0.1;
            particle.f_107216_ += (double)rand.m_188501_() * -0.25 * (double)rand.m_188501_() * 0.1;
            particle.f_107217_ += (double)rand.m_188501_() * (rand.m_188499_() ? -3.9 : 3.9) * (double)rand.m_188501_() * 0.1;
            particle.m_108335_(this.sprite());
            return particle;
        }
    }

    public record WanderingProvider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FireflyParticle particle = new FireflyParticle(level, x, y, z, 0.1f, 0.1f, 0.1f, 30, true);
            RandomSource rand = level.m_213780_();
            particle.f_107215_ += (double)rand.m_188501_() * (rand.m_188499_() ? -3.9 : 3.9) * (double)rand.m_188501_() * 0.1;
            particle.f_107216_ += (double)rand.m_188501_() * -0.25 * (double)rand.m_188501_() * 0.1;
            particle.f_107217_ += (double)rand.m_188501_() * (rand.m_188499_() ? -3.9 : 3.9) * (double)rand.m_188501_() * 0.1;
            particle.m_108335_(this.sprite());
            return particle;
        }
    }

    public record StationaryProvider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FireflyParticle particle = new FireflyParticle(level, x, y, z, 0.0f, 0.0f, 0.0f, 10, false);
            particle.m_108335_(this.sprite());
            return particle;
        }
    }
}

