/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class ClientboundUpdateRecipePacket {
    public static final ResourceLocation NULL = new ResourceLocation("null", "null");
    private final ResourceLocation id;
    private final ItemStack output;

    public ClientboundUpdateRecipePacket(@Nullable Recipe recipe, ItemStack output) {
        this(recipe == null ? NULL : recipe.m_6423_(), output);
    }

    public ClientboundUpdateRecipePacket(ResourceLocation id, ItemStack output) {
        this.id = id;
        this.output = output;
    }

    public static ClientboundUpdateRecipePacket decode(FriendlyByteBuf buffer) {
        ResourceLocation recipeId = buffer.m_130281_();
        ItemStack output = buffer.m_130267_();
        return new ClientboundUpdateRecipePacket(recipeId, output);
    }

    public static void encode(ClientboundUpdateRecipePacket message, FriendlyByteBuf buffer) {
        buffer.m_130085_(message.id);
        buffer.m_130055_(message.output);
    }

    public static void handle(ClientboundUpdateRecipePacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Recipe recipe = Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(message.id).orElse(null);
            Screen patt2278$temp = Minecraft.m_91087_().f_91080_;
            if (patt2278$temp instanceof BackpackScreen) {
                BackpackScreen screen = (BackpackScreen)patt2278$temp;
                ((BackpackBaseMenu)screen.m_6262_()).getWrapper().getUpgradeManager().craftingUpgrade.ifPresent(upgrade -> {
                    ((BackpackBaseMenu)screen.m_6262_()).getWrapper().getUpgradeManager().craftingUpgrade.get().resultSlots.m_6029_(recipe);
                    ((BackpackBaseMenu)screen.m_6262_()).getWrapper().getUpgradeManager().craftingUpgrade.get().resultSlots.m_6836_(0, message.output);
                });
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

