/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public class SortType {
    static String getStringForSort(ItemStack stack, Type type) {
        Item item = stack.m_41720_();
        String itemName = SortType.specialCases(stack);
        return BuiltInRegistries.f_257033_.m_7981_((Object)item) + itemName;
    }

    public static String getTabID(int tabID) {
        return tabID < 10 ? "00" + tabID : (tabID < 100 ? "0" + tabID : "999");
    }

    private static String specialCases(ItemStack stack) {
        Item item = stack.m_41720_();
        if (stack.m_41613_() != stack.m_41741_()) {
            return SortType.stackSize(stack);
        }
        if (item instanceof EnchantedBookItem) {
            return SortType.enchantedBookNameCase(stack);
        }
        if (item instanceof TieredItem) {
            return SortType.toolDurabilityCase(stack);
        }
        return item.m_5671_(stack);
    }

    private static String stackSize(ItemStack stack) {
        return stack.m_41720_().toString() + stack.m_41613_();
    }

    private static String enchantedBookNameCase(ItemStack stack) {
        ListTag enchants = EnchantedBookItem.m_41163_((ItemStack)stack);
        ArrayList<String> names = new ArrayList<String>();
        StringBuilder enchantNames = new StringBuilder();
        for (int i = 0; i < enchants.size(); ++i) {
            Enchantment enchant;
            CompoundTag enchantTag = enchants.m_128728_(i);
            ResourceLocation enchantID = ResourceLocation.m_135820_((String)enchantTag.m_128461_("id"));
            if (enchantID == null || (enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantID)) == null) continue;
            names.add(enchant.m_44700_(enchantTag.m_128451_("lvl")).getString());
        }
        Collections.sort(names);
        for (String enchant : names) {
            enchantNames.append(enchant).append(" ");
        }
        return stack.m_41720_() + " " + enchants.size() + " " + enchantNames;
    }

    private static String toolDurabilityCase(ItemStack stack) {
        return stack.m_41720_().toString() + stack.m_41773_();
    }

    public static enum Type {
        NAME,
        MOD,
        CATEGORY;

    }
}

