/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.init.ModMenuTypes;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BackpackBlockEntityMenu
extends BackpackBaseMenu {
    private final ContainerLevelAccess access;
    private final Block backpackBlock;
    private final int infniteAccessUser;

    public BackpackBlockEntityMenu(int windowID, Inventory inventory, FriendlyByteBuf data) {
        this(windowID, inventory, BackpackBlockEntityMenu.isInfiniteAccess(data), BackpackBlockEntityMenu.getBlockEntity(inventory, data));
    }

    public BackpackBlockEntityMenu(int windowID, Inventory inventory, int entityId, BackpackWrapper wrapper) {
        super((MenuType)ModMenuTypes.BACKPACK_BLOCK_MENU.get(), windowID, inventory, wrapper);
        this.access = ContainerLevelAccess.m_39289_((Level)this.player.m_9236_(), (BlockPos)this.getWrapper().getBackpackPos());
        this.backpackBlock = this.player.m_9236_().m_8055_(this.getWrapper().getBackpackPos()).m_60734_();
        this.infniteAccessUser = entityId;
        this.wrapper.addUser(inventory.f_35978_);
    }

    private static int isInfiniteAccess(FriendlyByteBuf data) {
        return data.readInt();
    }

    private static BackpackWrapper getBlockEntity(Inventory inventory, FriendlyByteBuf data) {
        Objects.requireNonNull(inventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockPos pos = data.m_130135_();
        BlockEntity blockEntityAtPos = inventory.f_35978_.m_9236_().m_7702_(pos);
        if (blockEntityAtPos instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)blockEntityAtPos;
            backpackBlockEntity.getWrapper().addUser(inventory.f_35978_);
            backpackBlockEntity.getWrapper().setBackpackPos(pos);
            return backpackBlockEntity.getWrapper();
        }
        throw new IllegalStateException("Block Entity is not correct! " + blockEntityAtPos);
    }

    @Override
    public boolean m_6875_(Player player) {
        return (Boolean)this.access.m_39299_((level, blockPos) -> !level.m_8055_(blockPos).m_60713_(this.backpackBlock) ? false : player.m_19879_() == this.infniteAccessUser || player.m_20275_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    @Override
    public void m_6877_(Player player) {
        if (player.f_36096_ instanceof BackpackBaseMenu && player.m_9236_().f_46443_) {
            return;
        }
        this.wrapper.playersUsing.remove(player);
        super.m_6877_(player);
    }
}

