/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class StorageAccessWrapper
implements IItemHandlerModifiable {
    public final BackpackWrapper wrapper;
    public final ItemStackHandler parent;

    public StorageAccessWrapper(BackpackWrapper wrapper, ItemStackHandler parent) {
        this.wrapper = wrapper;
        this.parent = parent;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.parent.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.parent.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.parent.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.tryVoiding(stack) && !simulate) {
            return ItemStack.f_41583_;
        }
        if (!this.wrapper.getMemorySlots().isEmpty()) {
            for (Pair<Integer, Pair<ItemStack, Boolean>> memorizedStack : this.wrapper.getMemorySlots()) {
                ItemStack insertResult;
                int result;
                if (((ItemStack)((Pair)memorizedStack.getSecond()).getFirst()).m_41720_() != stack.m_41720_() || (result = this.matchesStack(stack, memorizedStack)) == -1 || !(insertResult = this.parent.insertItem(result, stack, simulate)).m_41619_()) continue;
                return ItemStack.f_41583_;
            }
        }
        return this.wrapper.getUnsortableSlots().contains(slot) ? stack : this.parent.insertItem(slot, stack, simulate);
    }

    public int matchesStack(ItemStack inserted, Pair<Integer, Pair<ItemStack, Boolean>> memorizedStack) {
        if (((Boolean)((Pair)memorizedStack.getSecond()).getSecond()).booleanValue()) {
            return ItemStackUtils.isSameItemSameTags(inserted, (ItemStack)((Pair)memorizedStack.getSecond()).getFirst()) ? (Integer)memorizedStack.getFirst() : -1;
        }
        return ItemStack.m_41656_((ItemStack)inserted, (ItemStack)((ItemStack)((Pair)memorizedStack.getSecond()).getFirst())) ? (Integer)memorizedStack.getFirst() : -1;
    }

    public boolean tryVoiding(ItemStack stack) {
        return this.wrapper.getUpgradeManager().voidUpgrade.map(voidUpgrade -> voidUpgrade.canVoid(stack)).orElse(false);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.wrapper.getUnsortableSlots().contains(slot) ? ItemStack.f_41583_ : this.parent.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.parent.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.parent.isItemValid(slot, stack);
    }
}

