/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.buttons;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.buttons.Button;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.network.ServerboundAbilitySliderPacket;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class AbilitySliderButton
extends Button {
    private final WidgetElement abilitySliderElement = new WidgetElement(new Point(133, -95), new Point(18, 11));
    private final boolean isBlock;

    public AbilitySliderButton(BackpackScreen screen, boolean isBlock) {
        super(screen, screen.getWidthAdditions() + 133, screen.getImageHeight() - 95, 18, 11);
        this.isBlock = isBlock;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isBlock) {
            this.drawButton(guiGraphics, mouseX, mouseY, BackpackScreen.ICONS);
        } else if (CapabilityUtils.isWearingBackpack(((BackpackBaseMenu)this.screen.m_6262_()).getPlayerInventory().f_35978_)) {
            this.drawButton(guiGraphics, mouseX, mouseY, BackpackScreen.ICONS);
        }
    }

    public void drawButton(GuiGraphics guiGraphics, int mouseX, int mouseY, ResourceLocation texture) {
        if (this.screen.getWrapper().isAbilityEnabled()) {
            this.drawButton(guiGraphics, mouseX, mouseY, texture, 42, 54, 42, 76);
        } else {
            this.drawButton(guiGraphics, mouseX, mouseY, texture, 42, 65, 42, 76);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.inButton(mouseX, mouseY)) {
            if (this.screen.getWrapper().isAbilityEnabled()) {
                ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
                list.add(Component.m_237115_((String)"screen.travelersbackpack.ability_enabled").m_7532_());
                if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_TIMER_ABILITIES_LIST, this.screen.getWrapper().getBackpackStack()) || BackpackAbilities.isOnList(BackpackAbilities.BLOCK_TIMER_ABILITIES_LIST, this.screen.getWrapper().getBackpackStack())) {
                    list.add(this.screen.getWrapper().getCooldown() == 0 ? Component.m_237115_((String)"screen.travelersbackpack.ability_ready").m_7532_() : Component.m_237115_((String)BackpackDeathHelper.getConvertedTime(this.screen.getWrapper().getCooldown())).m_7532_());
                }
                guiGraphics.m_280245_(this.screen.getFont(), list, mouseX, mouseY);
            } else if (!((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue() || !BackpackAbilities.ALLOWED_ABILITIES.contains(this.screen.getWrapper().getBackpackStack().m_41720_())) {
                guiGraphics.m_280557_(this.screen.getFont(), (Component)Component.m_237115_((String)"screen.travelersbackpack.ability_disabled_config"), mouseX, mouseY);
            } else {
                guiGraphics.m_280557_(this.screen.getFont(), (Component)Component.m_237115_((String)"screen.travelersbackpack.ability_disabled"), mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue() || !BackpackAbilities.isAbilityEnabledInConfig(this.screen.getWrapper().getBackpackStack())) {
            return false;
        }
        if (this.isBlock) {
            if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.screen.getWrapper().getBackpackStack()) && this.inButton((int)mouseX, (int)mouseY)) {
                PacketDistributorHelper.sendToServer(new ServerboundAbilitySliderPacket(this.screen.getWrapper().getScreenID(), !this.screen.getWrapper().isAbilityEnabled()));
                this.screen.playUIClickSound();
                return true;
            }
        } else if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.screen.getWrapper().getBackpackStack()) && this.inButton((int)mouseX, (int)mouseY)) {
            PacketDistributorHelper.sendToServer(new ServerboundAbilitySliderPacket(this.screen.getWrapper().getScreenID(), !this.screen.getWrapper().isAbilityEnabled()));
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }
}

