/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.IBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.buttons.IButton;
import com.tiviacz.travelersbackpack.client.screens.widgets.InventoryScroll;
import com.tiviacz.travelersbackpack.client.screens.widgets.SettingsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.MemoryWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.SettingsWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.SupporterBadgeWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.UnsortablesWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.VisibilityWidget;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.Supporters;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BackpackSettingsScreen
extends AbstractContainerScreen<BackpackSettingsMenu>
implements MenuAccess<BackpackSettingsMenu>,
IBackpackScreen {
    public static final int TOP_BAR_OFFSET = 7;
    public int slotCount;
    boolean wider = false;
    public List<IButton> buttons = new ArrayList<IButton>();
    public SettingsWidget settingsWidget;
    public UnsortablesWidget unsortablesWidget;
    public MemoryWidget memoryWidget;
    public VisibilityWidget visibilityWidget;
    public SupporterBadgeWidget supporterBadgeWidget;
    private final BackpackWrapper wrapper;
    public List<Integer> lastUnsortableSlots;
    public List<Integer> unsortableSlots = new ArrayList<Integer>();
    public List<Pair<Integer, Pair<ItemStack, Boolean>>> lastMemorySlots;
    public List<Pair<Integer, Pair<ItemStack, Boolean>>> memorySlots = new ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>>();
    public boolean visibility;
    public InventoryScroll scroll = null;
    public int slotYPos;
    public boolean isScrollable = false;
    public int scrollAmount = 0;
    public static final int HEIGHT_WITHOUT_STORAGE = 118;
    public int slotsHeight;
    public int visibleSlots;
    public int visibleRows;

    public BackpackSettingsScreen(BackpackSettingsMenu backpackSettingsMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)backpackSettingsMenu, inventory, component);
        this.wrapper = backpackSettingsMenu.getWrapper();
        this.recalculate();
        this.updateBackpackSlotsPosition();
        this.updatePlayerSlotsPosition();
        this.lastUnsortableSlots = new ArrayList<Integer>(this.wrapper.getUnsortableSlots());
        this.unsortableSlots = new ArrayList<Integer>(this.lastUnsortableSlots);
        this.lastMemorySlots = new ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>>(this.wrapper.getMemorySlots());
        this.memorySlots = new ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>>(this.lastMemorySlots);
        this.visibility = NbtHelper.getOrDefault(this.wrapper.getBackpackStack(), "IsVisible", true);
    }

    @Override
    public BackpackWrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public Player getScreenPlayer() {
        return ((BackpackSettingsMenu)this.m_6262_()).player;
    }

    @Override
    public void sendDataToServer() {
        this.unsortablesWidget.sendDataToServer();
        this.memoryWidget.sendDataToServer();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initButtons();
        this.initWidgets();
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
        this.isScrollable = false;
        this.recalculate();
        this.m_7856_();
        ((BackpackSettingsMenu)this.m_6262_()).updateSlots();
        this.updateBackpackSlotsPosition();
        this.updatePlayerSlotsPosition();
    }

    public void recalculate() {
        boolean wideTexture;
        this.m_169413_();
        this.visibleSlots = this.slotCount = this.getWrapper().getStorage().getSlots();
        this.slotsHeight = this.calculateSlotHeight(this.slotCount > 81);
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.wider = wideTexture = this.slotCount > 81;
        this.visibleRows = (int)Math.ceil((double)this.slotCount / (double)this.getSlotsInRow());
        int playerInventoryHeight = 96;
        this.f_97726_ = wideTexture ? 212 : 176;
        this.f_97727_ = 22 + this.slotsHeight + playerInventoryHeight;
        this.updateDimensions();
        this.f_97731_ = 25 + this.visibleRows * 18;
        this.f_97730_ = 8;
        if (wideTexture) {
            this.f_97730_ += 18;
        }
        if (((BackpackSettingsMenu)this.f_97732_).m_38853_((int)0).f_40221_ >= 0) {
            this.slotYPos = ((BackpackSettingsMenu)this.f_97732_).m_38853_((int)0).f_40221_;
        }
    }

    public void updateDimensions() {
        int guiScaledHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        if (guiScaledHeight < this.f_97727_) {
            int displayableNumberOfRows = Math.min((guiScaledHeight - 118) / 18, this.getRows());
            int newImageHeight = 133 + this.calculateSlotHeight(displayableNumberOfRows);
            this.slotsHeight = this.calculateSlotHeight(displayableNumberOfRows);
            this.visibleSlots = displayableNumberOfRows * (this.slotCount > 81 ? 11 : 9);
            this.f_97727_ = newImageHeight;
            this.visibleRows = displayableNumberOfRows;
            this.isScrollable = true;
        }
    }

    public void renderInventoryBackground(GuiGraphics guiGraphics, int x, int y, ResourceLocation texture, int xSize, int slotsHeight) {
        int halfSlotHeight = slotsHeight / 2;
        guiGraphics.m_280218_(texture, x, y, 0, 0, xSize, 7 + halfSlotHeight);
        int playerInventoryHeight = 97;
        guiGraphics.m_280218_(texture, x, y + 7 + halfSlotHeight, 0, 256 - (playerInventoryHeight + halfSlotHeight), xSize, playerInventoryHeight + halfSlotHeight);
    }

    public void renderSlots(GuiGraphics guiGraphics, int x, int y, int slotCount) {
        int fullRows;
        int lastSlotRow = this.slotCount % this.getSlotsInRow();
        int visibleRows = this.visibleRows;
        int n = fullRows = this.isScrollable ? visibleRows : slotCount / this.getSlotsInRow();
        if (this.isScrollable && this.scrollAmount == this.getMaxScrollAmount() && lastSlotRow > 0) {
            --fullRows;
        }
        guiGraphics.m_280218_(BackpackScreen.SLOTS, x, y, 0, 0, this.getSlotsInRow() * 18, fullRows * 18);
        if (lastSlotRow > 0) {
            if (this.isScrollable) {
                if (this.scrollAmount == this.getMaxScrollAmount()) {
                    guiGraphics.m_280218_(BackpackScreen.SLOTS, x, y + fullRows * 18, 0, fullRows * 18, lastSlotRow * 18, 18);
                }
            } else {
                guiGraphics.m_280218_(BackpackScreen.SLOTS, x, y + fullRows * 18, 0, fullRows * 18, lastSlotRow * 18, 18);
            }
        }
    }

    public void renderScreen(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.m_6702_().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderBg(guiGraphics, x, y, mouseX, mouseY));
        boolean wideTexture = this.slotCount > 81;
        this.renderInventoryBackground(guiGraphics, x, y, wideTexture ? BackpackScreen.BACKGROUND_11 : BackpackScreen.BACKGROUND_9, this.f_97726_, this.slotsHeight);
        int slotsXOffset = 7;
        this.m_6702_().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderAboveBg(guiGraphics, x, y, mouseX, mouseY, partialTicks));
        this.renderSlots(guiGraphics, x + slotsXOffset, y + 7, this.slotCount);
    }

    public int calculateSlotHeight(int displayableRows) {
        return displayableRows * 18;
    }

    public int calculateSlotHeight(boolean wider) {
        int rowSlots = wider ? 11 : 9;
        int rows = (int)Math.ceil((double)this.slotCount / (double)rowSlots);
        return rows * 18;
    }

    @Override
    public Font getFont() {
        return this.f_96547_;
    }

    public void initWidgets() {
        this.settingsWidget = new SettingsWidget(this, new Point(this.f_97735_ + this.f_97726_ - 3, this.f_97736_ + 4 + 15), true);
        this.m_142416_(this.settingsWidget);
        this.unsortablesWidget = new UnsortablesWidget(this, new Point(this.f_97735_ + this.f_97726_ - 3, this.f_97736_ + 4 + 24 + 1 + 15));
        this.m_142416_(this.unsortablesWidget);
        this.memoryWidget = new MemoryWidget(this, new Point(this.f_97735_ + this.f_97726_ - 3, this.f_97736_ + 4 + 24 + 1 + 24 + 1 + 15), false);
        this.m_142416_(this.memoryWidget);
        if (this.getWrapper().getScreenID() == 2) {
            this.visibilityWidget = new VisibilityWidget(this, new Point(this.f_97735_ + this.f_97726_ - 3, this.f_97736_ + 4 + 24 + 1 + 24 + 1 + 24 + 1 + 15));
            this.m_142416_(this.visibilityWidget);
            if (this.getWrapper().isOwner(this.getScreenPlayer()) && Supporters.SUPPORTERS_REFERENCE.contains(this.getScreenPlayer().m_36316_().getName())) {
                this.supporterBadgeWidget = new SupporterBadgeWidget(this, new Point(this.f_97735_ + this.f_97726_ - 3, this.f_97736_ + 4 + 24 + 1 + 24 + 1 + 24 + 1 + 24 + 1 + 15));
                this.m_142416_(this.supporterBadgeWidget);
            }
        }
        if (this.isScrollable) {
            int scrollXPos = this.f_97735_ + 7;
            this.scroll = new InventoryScroll(this, Minecraft.m_91087_(), 4, this.visibleRows * 18, this.f_97736_ + 15 + 7, scrollXPos + this.getSlotsInRow() * 18);
            if (this.scrollAmount != 0) {
                this.scroll.setScrollDistance(this.scrollAmount);
            }
            this.m_142416_((GuiEventListener)this.scroll);
        }
    }

    @Override
    public void setScrollAmount(int scrollAmount) {
        this.scrollAmount = scrollAmount;
    }

    public void initButtons() {
        this.buttons.clear();
    }

    @Override
    public int getRows() {
        return (int)Math.ceil((double)this.slotCount / (double)this.getSlotsInRow());
    }

    public void closeTabs(SettingsWidgetBase openedWidget) {
        this.m_6702_().stream().filter(widget -> widget instanceof SettingsWidgetBase && widget != openedWidget).forEach(widget -> {
            ((SettingsWidgetBase)widget).tabOpened = false;
        });
    }

    public void updateWidgetsPosition(SettingsWidgetBase openedWidget) {
        this.closeTabs(openedWidget);
        List<GuiEventListener> widgets = this.m_6702_().stream().filter(w -> w instanceof SettingsWidgetBase).toList();
        for (int i = 0; i < widgets.size(); ++i) {
            SettingsWidgetBase previousWidget = null;
            SettingsWidgetBase currentWidget = (SettingsWidgetBase)widgets.get(i);
            if (i > 0) {
                previousWidget = (SettingsWidgetBase)widgets.get(i - 1);
            }
            if (previousWidget == null) continue;
            int[] previousWidgetPosAndSize = previousWidget.getWidgetSizeAndPos();
            currentWidget.updatePos(previousWidgetPosAndSize[1], previousWidgetPosAndSize[3] + 1);
        }
    }

    @Override
    public void updateBackpackSlotsPosition() {
        int allStorageSlots = this.slotCount;
        if (this.isScrollable) {
            int i;
            int scrollAmount = this.scrollAmount;
            int hiddenSlotsFirst = scrollAmount * this.getSlotsInRow();
            int movedSlots = this.visibleRows * this.getSlotsInRow() - hiddenSlotsFirst;
            int revealedSlots = scrollAmount * this.getSlotsInRow();
            int lastRowSlots = this.slotCount % this.getSlotsInRow();
            if (scrollAmount == this.getMaxScrollAmount() && lastRowSlots > 0) {
                revealedSlots -= this.getSlotsInRow();
                revealedSlots += lastRowSlots;
            }
            for (int i2 = 0; i2 < hiddenSlotsFirst; ++i2) {
                ((Slot)((BackpackSettingsMenu)this.f_97732_).f_38839_.get((int)i2)).f_40221_ = -1000;
            }
            int countSlots = 0;
            for (int i3 = hiddenSlotsFirst; i3 < hiddenSlotsFirst + movedSlots; ++i3) {
                ((Slot)((BackpackSettingsMenu)this.f_97732_).f_38839_.get((int)i3)).f_40221_ = this.slotYPos + (int)Math.floor((double)countSlots / (double)this.getSlotsInRow()) * 18;
                ++countSlots;
            }
            countSlots = 0;
            int lastY = this.slotYPos + (this.visibleRows - scrollAmount) * 18;
            for (i = hiddenSlotsFirst + movedSlots; i < hiddenSlotsFirst + movedSlots + revealedSlots; ++i) {
                ((Slot)((BackpackSettingsMenu)this.f_97732_).f_38839_.get((int)i)).f_40221_ = lastY + (int)Math.floor((double)countSlots / (double)this.getSlotsInRow()) * 18;
                ++countSlots;
            }
            for (i = hiddenSlotsFirst + movedSlots + revealedSlots; i < allStorageSlots; ++i) {
                ((Slot)((BackpackSettingsMenu)this.f_97732_).f_38839_.get((int)i)).f_40221_ = -1000;
            }
        }
    }

    public void updatePlayerSlotsPosition() {
        if (this.isScrollable) {
            int i;
            int firstPlayerSlotY = 36 + this.visibleRows * 18;
            int countSlots = 0;
            for (i = this.slotCount; i < this.slotCount + 27; ++i) {
                ((Slot)((BackpackSettingsMenu)this.f_97732_).f_38839_.get((int)i)).f_40221_ = firstPlayerSlotY + (int)Math.floor((double)countSlots / 9.0) * 18;
                ++countSlots;
            }
            for (i = this.slotCount + 27; i < this.slotCount + 36; ++i) {
                ((Slot)((BackpackSettingsMenu)this.f_97732_).f_38839_.get((int)i)).f_40221_ = firstPlayerSlotY + 54 + 4;
            }
        }
    }

    public int getSlotsInRow() {
        return this.wider ? 11 : 9;
    }

    public int getMaxScrollAmount() {
        return (int)Math.ceil((double)this.slotCount / (double)this.getSlotsInRow()) - (int)Math.ceil((double)this.visibleSlots / (double)this.getSlotsInRow());
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.buttons.forEach(button -> button.render(guiGraphics, mouseX, mouseY, partialTicks));
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        this.buttons.forEach(button -> button.renderTooltip(guiGraphics, mouseX, mouseY));
        this.m_6702_().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderTooltip(guiGraphics, mouseX, mouseY));
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.renderScreen(guiGraphics, x, y + 15, mouseX, mouseY, partialTicks);
        this.drawUnsortableSlots(guiGraphics);
        this.drawMemorySlots(guiGraphics);
    }

    public void drawUnsortableSlots(GuiGraphics guiGraphics) {
        if (this.unsortablesWidget.isTabOpened()) {
            if (!this.unsortableSlots.isEmpty()) {
                this.unsortableSlots.forEach(i -> guiGraphics.m_280218_(BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)i.intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)i.intValue()).f_40221_, 25, 55, 16, 16));
            }
        } else if (!this.lastUnsortableSlots.isEmpty()) {
            this.lastUnsortableSlots.forEach(i -> guiGraphics.m_280218_(BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)i.intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)i.intValue()).f_40221_, 25, 55, 16, 16));
        }
    }

    public void drawMemorySlots(GuiGraphics guiGraphics) {
        if (this.memoryWidget.isTabOpened()) {
            if (!this.memorySlots.isEmpty()) {
                this.memorySlots.forEach(pair -> {
                    if (((Boolean)((Pair)pair.getSecond()).getSecond()).booleanValue()) {
                        guiGraphics.m_280218_(BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_, 25, 73, 16, 16);
                    } else {
                        guiGraphics.m_280218_(BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_, 25, 91, 16, 16);
                    }
                    if (((BackpackSettingsMenu)this.m_6262_()).m_38853_((Integer)pair.getFirst()).m_7993_().m_41619_()) {
                        ItemStack itemstack = (ItemStack)((Pair)pair.getSecond()).getFirst();
                        guiGraphics.m_280203_(itemstack, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_);
                        guiGraphics.m_285944_(RenderType.m_285811_(), this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_ + 16, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_ + 16, 0x30FFFFFF);
                    }
                });
            }
        } else if (!this.lastMemorySlots.isEmpty()) {
            this.lastMemorySlots.forEach(pair -> {
                if (((BackpackSettingsMenu)this.m_6262_()).m_38853_((Integer)pair.getFirst()).m_7993_().m_41619_()) {
                    ItemStack itemstack = (ItemStack)((Pair)pair.getSecond()).getFirst();
                    guiGraphics.m_280203_(itemstack, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_);
                    guiGraphics.m_285944_(RenderType.m_285811_(), this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_, this.getGuiLeft() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40220_ + 16, this.getGuiTop() + ((BackpackSettingsMenu)this.m_6262_()).m_38853_((int)((Integer)pair.getFirst()).intValue()).f_40221_ + 16, 0x30FFFFFF);
                }
            });
        }
    }

    protected void m_6597_(Slot slot, int slotId, int button, ClickType type) {
        if (this.selectSlots(slot, button)) {
            return;
        }
        super.m_6597_(slot, slotId, button, type);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (this.scroll != null) {
            return this.scroll.m_6050_(mouseX, mouseY, scrollY);
        }
        return super.m_6050_(mouseX, mouseY, scrollY);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        Slot slot = this.getSlotUnderMouse();
        if (this.selectSlots(slot, button)) {
            return true;
        }
        for (GuiEventListener child : this.m_6702_()) {
            if (!child.m_5953_(mouseX, mouseY) || !child.m_7979_(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean selectSlots(Slot slot, int button) {
        if (slot != null && slot.f_40219_ >= 0 && slot.f_40219_ < this.wrapper.getStorage().getSlots()) {
            if (this.unsortablesWidget.isTabOpened()) {
                if (button == 0 && !this.unsortableSlots.contains(slot.f_40219_)) {
                    this.unsortableSlots.add(slot.f_40219_);
                    return true;
                }
                if (button == 1 && this.unsortableSlots.contains(slot.f_40219_)) {
                    this.unsortableSlots.remove((Object)slot.f_40219_);
                    return true;
                }
            }
            if (this.memoryWidget.isTabOpened()) {
                if (button == 0 && !this.memoryWidget.contains(slot.f_40219_, this.memorySlots)) {
                    if (slot.m_7993_().m_41619_()) {
                        return false;
                    }
                    this.memorySlots.add((Pair<Integer, Pair<ItemStack, Boolean>>)Pair.of((Object)slot.f_40219_, (Object)Pair.of((Object)(this.memoryWidget.matchComponents ? slot.m_7993_() : slot.m_7993_().m_41720_().m_7968_()), (Object)this.memoryWidget.matchComponents)));
                    return true;
                }
                if (button == 1 && this.memoryWidget.contains(slot.f_40219_, this.memorySlots)) {
                    this.memorySlots.removeIf(p -> (Integer)p.getFirst() == slot.f_40219_);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        GuiEventListener focused = this.m_7222_();
        if (focused != null && !focused.m_5953_(mouseX, mouseY) && focused instanceof WidgetBase) {
            WidgetBase widgetBase = (WidgetBase)focused;
            widgetBase.m_93692_(false);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public void playUIClickSound() {
        ((BackpackSettingsMenu)this.f_97732_).getPlayerInventory().f_35978_.m_9236_().m_5594_(((BackpackSettingsMenu)this.f_97732_).getPlayerInventory().f_35978_, ((BackpackSettingsMenu)this.f_97732_).getPlayerInventory().f_35978_.m_20183_(), (SoundEvent)SoundEvents.f_12490_.m_203334_(), SoundSource.MASTER, 0.25f, 1.0f);
    }

    public void m_7379_() {
        this.sendDataToServer();
        super.m_7379_();
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (ModClientEventHandler.OPEN_BACKPACK.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
            LocalPlayer playerEntity = this.getMinecraft().f_91074_;
            if (playerEntity != null) {
                this.m_7379_();
            }
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }
}

