/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.model.BackpackBlockModel;
import com.tiviacz.travelersbackpack.client.model.BackpackLayerModel;
import com.tiviacz.travelersbackpack.common.recipes.BackpackDyeRecipe;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.RenderHelper;
import com.tiviacz.travelersbackpack.util.Supporters;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class BackpackLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final RandomSource RANDOM = RandomSource.m_216335_((long)42L);

    public BackpackLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, AbstractClientPlayer clientPlayer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (TravelersBackpack.enableIntegration()) {
            return;
        }
        if (CapabilityUtils.isWearingBackpack((Player)clientPlayer)) {
            ItemStack stack = CapabilityUtils.getWearingBackpack((Player)clientPlayer);
            BackpackLayer.renderBackpackLayer(BackpackLayerModel.LAYER_MODEL, (HumanoidModel)this.m_117386_(), poseStack, bufferIn, packedLightIn, (LivingEntity)clientPlayer, stack);
        }
    }

    public static void renderBackpackLayer(BackpackLayerModel model, HumanoidModel humanoidModel, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, LivingEntity entity, ItemStack stack) {
        Item item;
        if (!NbtHelper.getOrDefault(stack, "IsVisible", true).booleanValue()) {
            return;
        }
        model.setLivingEntity(entity);
        model.setMultiBufferSource(bufferIn);
        if (entity.m_6844_(EquipmentSlot.CHEST).m_41619_() && !stack.m_41619_()) {
            model.setBackpackStack(stack);
        }
        if (!((item = stack.m_41720_()) instanceof TravelersBackpackItem)) {
            return;
        }
        TravelersBackpackItem travelersBackpackItem = (TravelersBackpackItem)item;
        boolean translucentType = travelersBackpackItem == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || travelersBackpackItem == ModItems.SNOW_TRAVELERS_BACKPACK.get();
        boolean cutoutType = travelersBackpackItem == ModItems.WARDEN_TRAVELERS_BACKPACK.get();
        ResourceLocation loc = travelersBackpackItem.getBackpackTexture();
        VertexConsumer vertexConsumer = bufferIn.m_6299_(translucentType ? RenderType.m_110470_((ResourceLocation)loc) : RenderType.m_110446_((ResourceLocation)loc));
        if (cutoutType) {
            vertexConsumer = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)loc));
        }
        poseStack.m_85836_();
        BackpackLayer.alignModel(poseStack, humanoidModel, model, entity);
        if (NbtHelper.has(stack, "Color") && stack.m_41720_() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
            loc = new ResourceLocation("travelersbackpack", "textures/model/dyed.png");
            vertexConsumer = bufferIn.m_6299_(RenderType.m_110446_((ResourceLocation)loc));
            Triple<Float, Float, Float> rgb = RenderHelper.intToRGB(BackpackDyeRecipe.getColor(stack));
            model.mainBody.m_104306_(poseStack, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, ((Float)rgb.getLeft()).floatValue(), ((Float)rgb.getMiddle()).floatValue(), ((Float)rgb.getRight()).floatValue(), 1.0f);
            loc = new ResourceLocation("travelersbackpack", "textures/model/dyed_extras.png");
            vertexConsumer = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)loc));
        }
        model.m_7695_(poseStack, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        loc = BackpackBlockModel.getSleepingBagTexture(NbtHelper.getOrDefault(stack, "SleepingBagColor", DyeColor.RED.m_41060_()));
        vertexConsumer = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)loc));
        model.sleepingBag.m_104301_(poseStack, vertexConsumer, packedLightIn, OverlayTexture.f_118083_);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BackpackLayer.renderSupporterStar(player, poseStack, model.mainBody, packedLightIn);
        }
        poseStack.m_85849_();
    }

    public static void alignModel(PoseStack poseStack, HumanoidModel parent, BackpackLayerModel backpackModel, LivingEntity entity) {
        if (entity.m_6047_()) {
            poseStack.m_85837_(0.0, -0.155, 0.025);
        }
        parent.m_102872_((HumanoidModel)backpackModel);
        backpackModel.setupAngles(parent);
        poseStack.m_85837_(0.0, 0.175, 0.325);
        poseStack.m_85841_(0.85f, 0.85f, 0.85f);
        if (entity.m_6162_()) {
            poseStack.m_252880_(0.0f, 0.8f, -0.165f);
            float scaleFactor = entity.m_6134_();
            poseStack.m_85841_(scaleFactor + 0.1f, scaleFactor + 0.1f, scaleFactor + 0.1f);
        }
    }

    private static void translateAndRotate(PoseStack poseStack, int x, int y, int z, float xRot, float yRot, float zRot, float xScale, float yScale, float zScale) {
        poseStack.m_252880_((float)x / 16.0f, (float)y / 16.0f, (float)z / 16.0f);
        if (xRot != 0.0f || yRot != 0.0f || zRot != 0.0f) {
            poseStack.m_252781_(new Quaternionf().rotationZYX(zRot, yRot, xRot));
        }
        if (xScale != 1.0f || yScale != 1.0f || zScale != 1.0f) {
            poseStack.m_85841_(xScale, yScale, zScale);
        }
    }

    private static void renderSupporterStar(Player player, PoseStack poseStack, ModelPart parent, int packedLightIn) {
        if (Supporters.SUPPORTERS.contains(player.m_36316_().getName())) {
            poseStack.m_85836_();
            BackpackLayer.translateAndRotate(poseStack, (int)parent.f_104200_, (int)parent.f_104201_, (int)parent.f_104202_, parent.f_104203_, parent.f_104204_, parent.f_104205_, parent.f_233553_, parent.f_233554_, parent.f_233555_);
            BakedModel starModel = Minecraft.m_91087_().m_91304_().getModel(ModClientEventHandler.STAR_MODEL);
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_85841_(0.4f, 0.4f, 0.4f);
            poseStack.m_85837_(0.15, 0.3, -0.2);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-10.0f));
            BackpackLayer.renderModel(poseStack, starModel, packedLightIn);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
    }

    private static void renderModel(PoseStack matrixStack, BakedModel model, int packedLightIn) {
        MultiBufferSource.BufferSource src = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer worldrenderer = src.m_6299_(RenderType.m_110452_((ResourceLocation)TextureAtlas.f_118259_));
        List quads = model.getQuads(null, null, RANDOM, ModelData.EMPTY, null);
        for (BakedQuad quad : quads) {
            worldrenderer.putBulkData(matrixStack.m_85850_(), quad, 1.0f, 1.0f, 1.0f, 1.0f, packedLightIn, OverlayTexture.f_118083_, true);
        }
        src.m_109911_();
    }
}

