/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack;

import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.compat.curios.TravelersBackpackCurio;
import com.tiviacz.travelersbackpack.compat.polymorph.PolymorphCompat;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.init.ModBlockEntityTypes;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModCreativeTabs;
import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModLootModifiers;
import com.tiviacz.travelersbackpack.init.ModMenuTypes;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.Supporters;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="travelersbackpack")
public class TravelersBackpack {
    public static final String MODID = "travelersbackpack";
    public static final Logger LOGGER = LogManager.getLogger();
    public static SimpleChannel NETWORK;
    public static boolean curiosLoaded;
    public static boolean accessoriesLoaded;
    public static boolean craftingTweaksLoaded;
    public static boolean corpseLoaded;
    public static boolean gravestoneLoaded;
    public static boolean toughasnailsLoaded;
    public static boolean comfortsLoaded;
    public static boolean endermanOverhaulLoaded;
    public static boolean jeiLoaded;
    public static boolean polymorphLoaded;

    public TravelersBackpack() {
        ForgeMod.enableMilkFluid();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)TravelersBackpackConfig.serverSpec);
        TravelersBackpack.readOldCommonConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TravelersBackpackConfig.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)TravelersBackpackConfig.clientSpec);
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::doClientStuff);
        ModItems.ITEMS.register(eventBus);
        ModItems.ENTITY_TYPES.register(eventBus);
        ModBlocks.BLOCKS.register(eventBus);
        ModBlockEntityTypes.BLOCK_ENTITY_TYPES.register(eventBus);
        ModMenuTypes.MENU_TYPES.register(eventBus);
        ModRecipeSerializers.SERIALIZERS.register(eventBus);
        ModFluids.FLUID_TYPES.register(eventBus);
        ModFluids.FLUIDS.register(eventBus);
        ModCreativeTabs.CREATIVE_MODE_TABS.register(eventBus);
        ModLootModifiers.LOOT_MODIFIER_SERIALIZERS.register(eventBus);
        curiosLoaded = ModList.get().isLoaded("curios");
        accessoriesLoaded = ModList.get().isLoaded("accessories");
        craftingTweaksLoaded = ModList.get().isLoaded("craftingtweaks");
        corpseLoaded = ModList.get().isLoaded("corpse");
        gravestoneLoaded = ModList.get().isLoaded("gravestone");
        toughasnailsLoaded = ModList.get().isLoaded("toughasnails");
        comfortsLoaded = ModList.get().isLoaded("comforts");
        endermanOverhaulLoaded = ModList.get().isLoaded("endermanoverhaul");
        jeiLoaded = ModList.get().isLoaded("jei");
        polymorphLoaded = ModList.get().isLoaded("polymorph");
        Supporters.fetchSupporters();
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModNetwork.registerNetworkChannel();
            TravelersBackpackBlock.registerDispenserBehaviour();
            EffectFluidRegistry.initEffects();
            TravelersBackpack.enableCraftingTweaks();
            TravelersBackpackItem.registerCauldronInteraction();
        });
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ModClientEventHandler.registerScreenFactories();
            ModClientEventHandler.registerBlockEntityRenderers();
            ModClientEventHandler.registerItemModelProperties();
        });
        if (curiosLoaded) {
            TravelersBackpackCurio.registerCurioRenderer();
        }
        if (polymorphLoaded) {
            PolymorphCompat.registerWidget();
        }
    }

    public static boolean enableIntegration() {
        return TravelersBackpack.enableCurios();
    }

    public static boolean enableCurios() {
        return curiosLoaded && (Boolean)TravelersBackpackConfig.SERVER.backpackSettings.backSlotIntegration.get() != false;
    }

    public static void enableCraftingTweaks() {
        if (craftingTweaksLoaded) {
            try {
                Class.forName("com.tiviacz.travelersbackpack.compat.craftingtweaks.TravelersBackpackCraftingGridProvider").getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isAnyGraveModInstalled() {
        return corpseLoaded || gravestoneLoaded;
    }

    public static void readOldCommonConfig() {
        Path path = FMLPaths.CONFIGDIR.get().resolve("travelersbackpack-common.toml");
        boolean isCommonBackpackSettingsSection = false;
        Boolean curiosIntegration = null;
        try (BufferedReader reader = Files.newBufferedReader(path);){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
                if (line.startsWith("[") && line.endsWith("]")) {
                    isCommonBackpackSettingsSection = line.equalsIgnoreCase("[common.backpackSettings]");
                    continue;
                }
                if (!isCommonBackpackSettingsSection || !line.startsWith("curiosIntegration") || (parts = line.split("=", 2)).length != 2) continue;
                curiosIntegration = Boolean.parseBoolean(parts[1].trim());
                break;
            }
            if (curiosIntegration != null) {
                System.out.println("curiosIntegration: " + curiosIntegration);
                TravelersBackpack.generateDefaultConfig(curiosIntegration);
            } else {
                System.out.println("curiosIntegration not found in the [common.backpackSettings] section.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void generateDefaultConfig(boolean curiosIntegration) {
        Path tomlFilePath = FMLPaths.GAMEDIR.get().resolve("defaultconfigs").resolve("travelersbackpack-server.toml");
        String tomlContent = "#Server config settings\n[server]\n\n    [server.backpackSettings]\n        #If true, backpack can only be worn by placing it in Curios or Accessories 'Back' slot\n        #WARNING - Remember to TAKE OFF BACKPACK BEFORE enabling or disabling this integration!! - if not you'll lose your backpack\n        backSlotIntegration = false\n";
        if (curiosIntegration) {
            tomlContent = "#Server config settings\n[server]\n\n    [server.backpackSettings]\n        #If true, backpack can only be worn by placing it in Curios or Accessories 'Back' slot\n        #WARNING - Remember to TAKE OFF BACKPACK BEFORE enabling or disabling this integration!! - if not you'll lose your backpack\n        backSlotIntegration = true\n";
        }
        try (BufferedWriter writer = Files.newBufferedWriter(tomlFilePath, new OpenOption[0]);){
            writer.write(tomlContent);
            System.out.println("TOML file generated successfully: " + tomlFilePath.toAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

