/*
 * Decompiled with CFR 0.152.
 */
package cofh.toolscomplement.common.config;

import cofh.core.common.config.IBaseConfig;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;

public class ArmorConfig
implements IBaseConfig {
    protected String name;
    protected int durabilityFactor;
    protected int[] defenseAmounts;
    protected int enchantability;
    protected float toughness;
    protected float knockbackResist;
    private Supplier<Integer> configDurabilityFactor;
    private Supplier<Integer>[] configDefenseAmounts = new Supplier[4];
    private Supplier<Integer> configEnchantability;
    private ForgeConfigSpec.DoubleValue configToughness;
    private ForgeConfigSpec.DoubleValue configKnockbackResist;

    public ArmorConfig(String name, int durabilityFactor, int[] defenseAmounts, int enchantability, float toughness, float knockbackResist) {
        this.name = name;
        this.durabilityFactor = durabilityFactor;
        this.defenseAmounts = defenseAmounts;
        this.enchantability = enchantability;
        this.toughness = toughness;
        this.knockbackResist = knockbackResist;
    }

    public int getDurabilityFactor() {
        return this.configDurabilityFactor.get();
    }

    public int[] getDefenseAmounts() {
        return new int[]{this.configDefenseAmounts[0].get(), this.configDefenseAmounts[1].get(), this.configDefenseAmounts[2].get(), this.configDefenseAmounts[3].get()};
    }

    public int getEnchantability() {
        return this.configEnchantability.get();
    }

    public float getToughness() {
        double cfg = (Double)this.configToughness.get();
        return (float)cfg;
    }

    public float getKnockbackResist() {
        double cfg = (Double)this.configKnockbackResist.get();
        return (float)cfg;
    }

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.push(this.name);
        this.configDurabilityFactor = builder.comment("Relative durability of this armor type.").defineInRange("Durability", this.durabilityFactor, 1, 128);
        this.configEnchantability = builder.comment("Enchantability of this armor type.").defineInRange("Enchantability", this.enchantability, 0, 128);
        String[] armor = new String[]{"Boots", "Legplates", "Chestplate", "Helmet"};
        for (int i = 0; i < 4; ++i) {
            this.configDefenseAmounts[i] = builder.comment("Defense provided by " + armor[i] + ".").defineInRange(armor[i] + " Defense", this.defenseAmounts[i], 0, 20);
        }
        this.configToughness = builder.comment("Toughness provided by each piece of armor.").defineInRange("Toughness", (double)this.toughness, 0.0, 10.0);
        this.configKnockbackResist = builder.comment("Knockback resistance provided by each piece of armor.").defineInRange("Knockback Resist", (double)this.knockbackResist, 0.0, 10.0);
        builder.pop();
    }

    public void refresh() {
    }
}

