/*
 * Decompiled with CFR 0.152.
 */
package com.mystchonky.tomeofblood.common.registry;

import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.perk.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.PerkSlot;
import com.hollingsworth.arsnouveau.api.registry.FamiliarRegistry;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.mystchonky.tomeofblood.common.glyphs.EffectSentientHarm;
import com.mystchonky.tomeofblood.common.glyphs.EffectSentientWrath;
import com.mystchonky.tomeofblood.common.registry.ItemRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.ItemLike;

public class IntegrationRegistry {
    public static SpellSchool BLOODMAGIC = new SpellSchool("bloodmagic");
    public static List<AbstractSpellPart> registeredSpells = new ArrayList<AbstractSpellPart>();
    public static List<AbstractFamiliarHolder> registeredFamiliars = new ArrayList<AbstractFamiliarHolder>();

    public static void init() {
        IntegrationRegistry.registerGlyphs();
        IntegrationRegistry.registerFamiliars();
    }

    public static void postInit() {
        IntegrationRegistry.registerSounds();
        IntegrationRegistry.registerPerkProviders();
    }

    public static void registerGlyphs() {
        IntegrationRegistry.registerSpellPart((AbstractSpellPart)EffectSentientHarm.INSTANCE);
        IntegrationRegistry.registerSpellPart((AbstractSpellPart)EffectSentientWrath.INSTANCE);
    }

    public static void registerFamiliars() {
    }

    public static void registerSounds() {
    }

    public static void registerSpellPart(AbstractSpellPart spellPart) {
        GlyphRegistry.registerSpell((AbstractSpellPart)spellPart);
        registeredSpells.add(spellPart);
    }

    public static void registerFamiliarHolder(AbstractFamiliarHolder familiarHolder) {
        FamiliarRegistry.registerFamiliar((AbstractFamiliarHolder)familiarHolder);
        registeredFamiliars.add(familiarHolder);
    }

    public static void registerPerkProviders() {
        PerkRegistry.registerPerkProvider((ItemLike)((ItemLike)ItemRegistry.LIVING_MAGE_HOOD.get()), stack -> new ArmorPerkHolder(stack, List.of(List.of(PerkSlot.ONE), List.of(PerkSlot.ONE, PerkSlot.TWO), List.of(PerkSlot.ONE, PerkSlot.THREE))));
        PerkRegistry.registerPerkProvider((ItemLike)((ItemLike)ItemRegistry.LIVING_MAGE_ROBES.get()), stack -> new ArmorPerkHolder(stack, List.of(List.of(), List.of(), List.of())));
        PerkRegistry.registerPerkProvider((ItemLike)((ItemLike)ItemRegistry.LIVING_MAGE_LEGGINGS.get()), stack -> new ArmorPerkHolder(stack, List.of(List.of(PerkSlot.ONE), List.of(PerkSlot.ONE, PerkSlot.TWO), List.of(PerkSlot.ONE, PerkSlot.ONE, PerkSlot.THREE))));
        PerkRegistry.registerPerkProvider((ItemLike)((ItemLike)ItemRegistry.LIVING_MAGE_BOOTS.get()), stack -> new ArmorPerkHolder(stack, List.of(List.of(PerkSlot.ONE), List.of(PerkSlot.ONE, PerkSlot.ONE), List.of(PerkSlot.ONE, PerkSlot.ONE, PerkSlot.TWO))));
    }
}

