/*
 * Decompiled with CFR 0.152.
 */
package com.mystchonky.tomeofblood.common.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.hollingsworth.arsnouveau.api.perk.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.hollingsworth.arsnouveau.common.armor.AnimatedMagicArmor;
import com.mystchonky.tomeofblood.client.renderer.ToBGenericModel;
import com.mystchonky.tomeofblood.client.renderer.item.LivingMageArmorRenderer;
import com.mystchonky.tomeofblood.common.registry.ItemRegistry;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import wayoftime.bloodmagic.common.item.ArmorMaterialLiving;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.ExpandedArmor;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.living.ILivingContainer;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.living.LivingUtil;

public class LivingMageArmorItem
extends AnimatedMagicArmor
implements ILivingContainer,
ExpandedArmor {
    public LivingMageArmorItem(ArmorItem.Type slot) {
        super(ArmorMaterialLiving.INSTANCE, slot, (GeoModel)new ToBGenericModel("living_mage_armor", "item/living_mage_armor").withEmptyAnim());
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_41720_() == BloodMagicItems.REAGENT_BINDING.get() || super.m_6832_(toRepair, repair);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        if (this != ItemRegistry.LIVING_MAGE_ROBES.get()) {
            return super.damageItem(stack, amount, entity, onBroken);
        }
        int durRemaining = stack.m_41776_() - 1 - stack.m_41773_();
        return Math.max(Math.min(durRemaining, amount), 0);
    }

    public void damageArmor(LivingEntity livingEntity, ItemStack stack, DamageSource source, float damage, EquipmentSlot slot) {
        if (slot == EquipmentSlot.CHEST && damage > (float)(this.m_41462_() - stack.m_41773_())) {
            livingEntity.m_6469_(livingEntity.m_269291_().m_269425_(), 2.0f);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        LivingStats stats;
        HashMultimap modifiers = HashMultimap.create();
        modifiers.putAll(super.getAttributeModifiers(slot, stack));
        if (slot == EquipmentSlot.CHEST && (stats = this.getLivingStats(stack)) != null) {
            stats.getUpgrades().forEach((arg_0, arg_1) -> LivingMageArmorItem.lambda$getAttributeModifiers$0(stats, (Multimap)modifiers, arg_0, arg_1));
        }
        return modifiers;
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return this.hasElytraUpgrade(stack, entity) && stack.m_41773_() < stack.m_41776_() - 1;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        if (!entity.m_9236_().f_46443_ && (flightTicks + 1) % 40 == 0) {
            stack.m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.CHEST));
        }
        return true;
    }

    public boolean hasElytraUpgrade(ItemStack stack, LivingEntity entity) {
        if (stack.m_41720_() instanceof LivingMageArmorItem && entity instanceof Player && LivingUtil.hasFullSet((Player)((Player)entity))) {
            return LivingStats.fromPlayer((Player)((Player)entity), (boolean)true).getLevel(((LivingUpgrade)LivingArmorRegistrar.UPGRADE_ELYTRA.get()).getKey()) > 0;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        ILivingContainer.appendLivingTooltip((ItemStack)stack, (LivingStats)this.getLivingStats(stack), tooltip, (boolean)true);
    }

    public String getColor(ItemStack object) {
        IPerkHolder perkHolder = PerkUtil.getPerkHolder((ItemStack)object);
        if (!(perkHolder instanceof ArmorPerkHolder)) {
            return "red";
        }
        ArmorPerkHolder data = (ArmorPerkHolder)perkHolder;
        return data.getColor() == null || data.getColor().isEmpty() ? "red" : data.getColor();
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        GenericModel genericModel = (GenericModel)this.model;
        return new ResourceLocation("tomeofblood", "textures/" + genericModel.textPathRoot + "/" + genericModel.name + "_" + this.getColor(stack) + ".png").toString();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new LivingMageArmorRenderer((GeoModel<AnimatedMagicArmor>)LivingMageArmorItem.this.getArmorModel());
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$0(LivingStats stats, Multimap modifiers, LivingUpgrade k, Double v) {
        if (k.getAttributeProvider() != null) {
            k.getAttributeProvider().handleAttributes(stats, modifiers, UUID.nameUUIDFromBytes(k.getKey().toString().getBytes()), k, k.getLevel(v.intValue()));
        }
    }
}

