/*
 * Decompiled with CFR 0.152.
 */
package com.mystchonky.tomeofblood.common.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import com.mystchonky.tomeofblood.TomeOfBlood;
import com.mystchonky.tomeofblood.client.registry.ParticleRegistry;
import com.mystchonky.tomeofblood.common.glyphs.GlyphLibrary;
import com.mystchonky.tomeofblood.common.registry.IntegrationRegistry;
import com.mystchonky.tomeofblood.common.registry.MobEffectRegistry;
import com.mystchonky.tomeofblood.common.util.DemonWillUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.item.soul.ItemSentientSword;
import wayoftime.bloodmagic.will.PlayerDemonWillHandler;

public class EffectSentientWrath
extends AbstractEffect
implements IDamageEffect {
    public static EffectSentientWrath INSTANCE = new EffectSentientWrath();

    public EffectSentientWrath() {
        super(TomeOfBlood.prefix(GlyphLibrary.EffectSentientWrath), "Sentient Wrath");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        LivingEntity target;
        block8: {
            block7: {
                Entity entity = rayTraceResult.m_82443_();
                if (!(entity instanceof LivingEntity)) break block7;
                target = (LivingEntity)entity;
                if (world instanceof ServerLevel) break block8;
            }
            return;
        }
        ServerLevel level = (ServerLevel)world;
        if (!(shooter instanceof Player)) {
            return;
        }
        Player player = (Player)shooter;
        EnumDemonWillType type = DemonWillUtil.getActiveTypeFromPlayer(spellContext);
        int souls = (int)PlayerDemonWillHandler.getTotalDemonWill((EnumDemonWillType)type, (Player)player);
        int bracket = DemonWillUtil.getBracket(type, souls);
        Vec3 vec = this.safelyGetHitPos((HitResult)rayTraceResult);
        float baseDamage = (float)((Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier());
        double range = 3.0 + spellStats.getAoeMultiplier();
        int duration = (int)((double)((Integer)this.POTION_TIME.get()).intValue() + (double)((Integer)this.EXTEND_TIME.get()).intValue() * spellStats.getDurationMultiplier());
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
        if (!target.m_21023_((MobEffect)MobEffectRegistry.MARKED.get())) {
            target.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.MARKED.get(), 20 * duration, 1));
            this.attemptDamage((Level)level, shooter, spellStats, spellContext, resolver, (Entity)target, this.buildDamageSource((Level)level, shooter), baseDamage);
            targets.add(target);
        } else {
            float heavyDamage = baseDamage + 2.0f + DemonWillUtil.getExtraDamage(type, bracket);
            this.heavyAttack(vec, level, shooter, target, spellStats, spellContext, resolver, duration, heavyDamage);
            targets.add(target);
            for (LivingEntity mob : world.m_45976_(LivingEntity.class, new AABB(target.m_20182_().m_82520_(range, range, range), target.m_20182_().m_82492_(range, range, range)))) {
                if (mob.equals((Object)target) || mob.equals((Object)shooter)) continue;
                vec = mob.m_20182_();
                this.heavyAttack(vec, level, shooter, mob, spellStats, spellContext, resolver, duration, heavyDamage);
                targets.add(mob);
            }
        }
        double willCost = ItemSentientSword.soulDrainPerSwing[Math.max(bracket, 0)] * (double)targets.size() * (targets.size() > 1 ? 0.75 : 1.0);
        PlayerDemonWillHandler.consumeDemonWill((EnumDemonWillType)type, (Player)player, (double)willCost);
        targets.stream().filter(it -> !it.m_6084_()).findAny().ifPresent(it -> this.applyEffectOnKill(player, type, duration));
    }

    public void heavyAttack(Vec3 vec, ServerLevel level, LivingEntity shooter, LivingEntity target, SpellStats stats, SpellContext context, SpellResolver resolver, int duration, float damage) {
        if (this.attemptDamage((Level)level, shooter, stats, context, resolver, (Entity)target, this.buildDamageSource((Level)level, shooter), damage)) {
            level.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.WRATH_SLASH.get()), vec.f_82479_, vec.f_82480_ + 0.5, vec.f_82481_, 1, ParticleUtil.inRange((double)-0.1, (double)0.1), ParticleUtil.inRange((double)-0.1, (double)0.1), ParticleUtil.inRange((double)-0.1, (double)0.1), 0.3);
            target.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.MARKED.get(), 20 * duration));
        }
    }

    public void applyEffectOnKill(Player player, EnumDemonWillType type, int duration) {
        if (type == EnumDemonWillType.DEFAULT) {
            return;
        }
        MobEffectInstance instance = switch (type) {
            case EnumDemonWillType.CORROSIVE -> new MobEffectInstance(MobEffects.f_19606_, duration * 20);
            case EnumDemonWillType.VENGEFUL -> new MobEffectInstance(MobEffects.f_19596_, duration * 20);
            case EnumDemonWillType.STEADFAST -> new MobEffectInstance(MobEffects.f_19617_, duration * 20, 127);
            case EnumDemonWillType.DESTRUCTIVE -> new MobEffectInstance((MobEffect)ModPotions.SPELL_DAMAGE_EFFECT.get(), duration * 20);
            default -> throw new IllegalStateException("Unexpected value: " + type);
        };
        player.m_7292_(instance);
        if (type == EnumDemonWillType.STEADFAST) {
            float extra = player.m_6103_();
            player.m_7911_(Math.min(extra + player.m_21233_() * 0.2f, 10.0f));
        }
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 3.0);
        this.addAmpConfig(builder, 2.0);
        this.addPotionConfig(builder, 20);
        this.addExtendTimeConfig(builder, 5);
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
    }

    protected int getDefaultManaCost() {
        return 40;
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAOE.INSTANCE, AugmentFortune.INSTANCE});
    }

    public String getBookDescription() {
        return "Marks a target on first hit. Attacking a marked target will do a scaling heavy attack in a radius and Marks all targets. Consumes Will. $(br2)Grants player bonuses on kill when not using Raw will.$(br2)Corrosive - Resistance$(br)Vengeful - Speed$(br)Steadfast - Absorption$(br)Destructive - Spell Power";
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @NotNull
    protected Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{IntegrationRegistry.BLOODMAGIC});
    }
}

