/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.util;

import java.text.DecimalFormat;
import net.minecraft.network.chat.Style;

public class FormattingUtil {
    public static String getTranslatable(String text) {
        return "text.thoriumreactors.inventory." + text;
    }

    public static float getTurbineGenerationModifier(float rpm) {
        if (rpm < 100.0f) {
            return 0.1f;
        }
        if (rpm < 200.0f) {
            return 0.6f;
        }
        if (rpm < 300.0f) {
            return 1.3f;
        }
        if (rpm < 400.0f) {
            return 2.1f;
        }
        if (rpm < 500.0f) {
            return 3.3f;
        }
        if (rpm < 600.0f) {
            return 3.5f;
        }
        if (rpm < 700.0f) {
            return 4.3f;
        }
        if (rpm < 800.0f) {
            return 5.1f;
        }
        if (rpm < 900.0f) {
            return 6.2f;
        }
        if (rpm < 1000.0f) {
            return 7.0f;
        }
        if (rpm < 1100.0f) {
            return 9.0f;
        }
        if (rpm < 1200.0f) {
            return 10.0f;
        }
        if (rpm < 1300.0f) {
            return 11.0f;
        }
        if (rpm < 1400.0f) {
            return 14.0f;
        }
        if (rpm < 1500.0f) {
            return 17.0f;
        }
        if (rpm < 1600.0f) {
            return 21.0f;
        }
        if (rpm < 1700.0f) {
            return 29.0f;
        }
        if (rpm < 1800.0f) {
            return 38.0f;
        }
        if (rpm < 1900.0f) {
            return 47.0f;
        }
        if (rpm < 1950.0f) {
            return 55.0f;
        }
        if (rpm < 2000.0f) {
            return 58.0f;
        }
        if (rpm < 2050.0f) {
            return 55.0f;
        }
        if (rpm < 2100.0f) {
            return 47.0f;
        }
        if (rpm < 2200.0f) {
            return 39.0f;
        }
        if (rpm < 2300.0f) {
            return 34.0f;
        }
        if (rpm < 2400.0f) {
            return 31.0f;
        }
        return 28.0f;
    }

    public static String formatNum(float num) {
        DecimalFormat formatter = new DecimalFormat("0.00");
        if (num >= 1.0E9f) {
            return formatter.format(num / 1.0E9f).replaceAll(",", ".") + " GFE";
        }
        if (num >= 1000000.0f) {
            return formatter.format(num / 1000000.0f).replaceAll(",", ".") + " MFE";
        }
        if (num >= 1000.0f) {
            return formatter.format(num / 1000.0f).replaceAll(",", ".") + " kFE";
        }
        return (int)num + " FE";
    }

    public static String formatPercentNum(float num, float max) {
        DecimalFormat formatter = new DecimalFormat("0.00");
        String formatted = formatter.format(num / max * 100.0f).replaceAll(",", ".") + " %";
        return formatted.equals("NaN %") ? "0 %" : formatted;
    }

    public static String formatPercentNum(float num, float max, boolean showDecimals) {
        DecimalFormat formatter = new DecimalFormat(showDecimals ? "0.00" : "0");
        String formatted = formatter.format(num / max * 100.0f).replaceAll(",", ".") + " %";
        return formatted.equals("NaN %") ? "0 %" : formatted.replaceAll("-", "");
    }

    public static String formatEnergy(float num) {
        DecimalFormat formatter = new DecimalFormat("0.00");
        if (num >= 1.0E9f) {
            return formatter.format(num / 1.0E9f).replaceAll(",", ".") + " GFE";
        }
        if (num >= 1000000.0f) {
            return formatter.format(num / 1000000.0f).replaceAll(",", ".") + " MFE";
        }
        if (num >= 1000.0f) {
            return formatter.format(num / 1000.0f).replaceAll(",", ".") + " kFE";
        }
        return (float)Math.round(num * 100.0f) / 100.0f + " FE";
    }

    public static String formatEnergyComma(float num) {
        DecimalFormat formatter = new DecimalFormat("0.00");
        if (num >= 1.0E9f) {
            return formatter.format(num / 1.0E9f) + " GFE";
        }
        if (num >= 1000000.0f) {
            return formatter.format(num / 1000000.0f) + " MFE";
        }
        if (num >= 1000.0f) {
            return formatter.format(num / 1000.0f) + " kFE";
        }
        return (float)Math.round(num * 100.0f) / 100.0f + " FE";
    }

    public static Style hex(int hex) {
        return Style.f_131099_.m_178520_(hex);
    }
}

