/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.registration.ModRecipes;

public class ThoriumCraftingRecipe
implements Recipe<SimpleContainer> {
    public static final int MAX_WIDTH = 5;
    public static final int MAX_HEIGHT = 5;
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;

    public ThoriumCraftingRecipe(ResourceLocation id, NonNullList<Ingredient> recipeItems, ItemStack output) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean matches(@NotNull SimpleContainer container, Level level) {
        if (level.m_5776_()) {
            return false;
        }
        NonNullList currentItems = NonNullList.m_122780_((int)25, (Object)ItemStack.f_41583_);
        for (int i = 0; i < 25; ++i) {
            currentItems.set(i, (Object)(container.m_8020_(i).m_150930_(Items.f_41852_) ? ItemStack.f_41583_ : container.m_8020_(i)));
        }
        return this.isRecipe((NonNullList<ItemStack>)currentItems);
    }

    public boolean isRecipe(NonNullList<ItemStack> currentItems) {
        int airs = 0;
        int s = this.recipeItems.size();
        for (int i = 0; i < s; ++i) {
            if (!((Ingredient)this.recipeItems.get(i)).test((ItemStack)currentItems.get(i))) {
                return false;
            }
            if (!((ItemStack)currentItems.get(i)).m_150930_(Items.f_41852_)) continue;
            airs = (byte)(airs + 1);
        }
        return airs != 25;
    }

    @NotNull
    public ItemStack assemble(@NotNull SimpleContainer container, @Nullable RegistryAccess pRegistryAccess) {
        return this.output;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@Nullable RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.THORIUM_RECIPE_TYPE.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public static class Serializer
    implements RecipeSerializer<ThoriumCraftingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("thoriumreactors", "thorium_crafting");

        public ThoriumCraftingRecipe fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"result"));
            JsonArray pattern = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"pattern");
            JsonObject ingredients = GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"key");
            NonNullList recipeItems = NonNullList.m_122780_((int)25, (Object)Ingredient.f_43901_);
            if (pattern.size() == 0) {
                throw new IllegalArgumentException("Invalid pattern: Recipe height cannot be 0!");
            }
            if (pattern.size() > 5) {
                throw new IllegalArgumentException("Invalid pattern: Recipe height cannot be bigger than 5! (Value: " + pattern.size() + ")");
            }
            int index = 0;
            for (int i = 0; i < pattern.size(); ++i) {
                String[] current = pattern.get(i).getAsString().split("");
                if (Objects.equals(current[0], "")) {
                    throw new IllegalArgumentException("Invalid pattern: Recipe width cannot be 0!");
                }
                if (current.length > 5) {
                    throw new IllegalArgumentException("Invalid pattern: Recipe width cannot be bigger than 5! (Value: " + current.length + ")");
                }
                for (int e = 0; e < current.length; ++e) {
                    if (!ingredients.has(current[e]) && !Objects.equals(current[e], " ")) {
                        throw new IllegalArgumentException("Invalid pattern: Recipe key not existing! (Value: " + current[e] + ")");
                    }
                    recipeItems.set(index, (Object)(!Objects.equals(current[e], " ") ? Ingredient.m_43917_((JsonElement)ingredients.get(current[e])) : Ingredient.f_43901_));
                    ++index;
                }
            }
            return new ThoriumCraftingRecipe(pRecipeId, (NonNullList<Ingredient>)recipeItems, output);
        }

        @Nullable
        public ThoriumCraftingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList nonnulllist = NonNullList.m_122780_((int)25, (Object)Ingredient.f_43901_);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack itemstack = buf.m_130267_();
            return new ThoriumCraftingRecipe(id, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public void toNetwork(FriendlyByteBuf buf, ThoriumCraftingRecipe recipe) {
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(recipe.output);
        }
    }
}

