/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.registration.ModRecipes;
import unhappycodings.thoriumreactors.common.util.FluidParseUtil;

public class EvaporatingRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final FluidStack inputTank;
    private final Ingredient outputSlot;
    private final int operationAfterTicks;
    private final int ticks;

    public EvaporatingRecipe(ResourceLocation id, Ingredient inputSlot, FluidStack inputTank, int ticks, int operationAfterTicks) {
        this.id = id;
        this.inputTank = inputTank;
        this.outputSlot = inputSlot;
        this.ticks = ticks;
        this.operationAfterTicks = operationAfterTicks;
    }

    public boolean matches(@NotNull SimpleContainer container, Level level) {
        return false;
    }

    public boolean matchesFluid(FluidStack inputFluid) {
        return this.inputTank.getFluid().m_6212_(inputFluid.getFluid()) && this.inputTank.getAmount() <= inputFluid.getAmount();
    }

    @NotNull
    public ItemStack assemble(@NotNull SimpleContainer container, @Nullable RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@Nullable RegistryAccess pRegistryAccess) {
        return this.outputSlot.m_43908_()[0];
    }

    public int getOperationAfterTicks() {
        return this.operationAfterTicks;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.EVAPORATING_RECIPE_TYPE.get();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[0]);
    }

    public FluidStack getFluidIngredient() {
        return this.inputTank;
    }

    public int getTicks() {
        return this.ticks;
    }

    public static class Serializer
    implements RecipeSerializer<EvaporatingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("thoriumreactors", "evaporating");

        @NotNull
        public EvaporatingRecipe fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject pSerializedRecipe) {
            Ingredient output = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output").getAsJsonObject("slot-0"));
            if (output.m_43947_()) {
                throw new IllegalArgumentException("Invalid pattern: Input ingredient must be set! (" + output + ")");
            }
            FluidStack inputTank = FluidParseUtil.readFluid(GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"input").getAsJsonObject("tank-0"));
            if (inputTank.isEmpty()) {
                throw new IllegalArgumentException("Invalid pattern: Input fluid must be set! (" + inputTank + ")");
            }
            int ticks = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"ticks");
            if (ticks <= 0 || ticks > 2500) {
                throw new IllegalArgumentException("Invalid pattern: Needed ticks must be in between 1 and 2500! (" + ticks + ")");
            }
            int operationAfterTicks = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"operationAfterTicks");
            if (operationAfterTicks <= 0 || operationAfterTicks > 1000) {
                throw new IllegalArgumentException("Invalid pattern: Needed ticks must be in between 1 and 1000! (" + operationAfterTicks + ")");
            }
            return new EvaporatingRecipe(pRecipeId, output, inputTank, ticks, operationAfterTicks);
        }

        @Nullable
        public EvaporatingRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            Ingredient outputSlot = Ingredient.m_43940_((FriendlyByteBuf)buf);
            FluidStack inputTank = buf.readFluidStack();
            int ticks = buf.readInt();
            int operationAfterTicks = buf.readInt();
            return new EvaporatingRecipe(id, outputSlot, inputTank, ticks, operationAfterTicks);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, EvaporatingRecipe recipe) {
            recipe.outputSlot.m_43923_(buf);
            buf.writeFluidStack(recipe.inputTank);
            buf.writeInt(recipe.ticks);
            buf.writeInt(recipe.operationAfterTicks);
        }
    }
}

