/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.registration.ModRecipes;

public class BlastingRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final Ingredient inputLeft;
    private final Ingredient inputRight;
    private final ItemStack outputLeft;
    private final ItemStack outputRight;
    private final int secondaryChance;
    private final int ticks;
    private final int temperature;

    public BlastingRecipe(ResourceLocation id, Ingredient inputLeft, Ingredient inputRight, ItemStack output, ItemStack secondOutput, int secondaryChance, int ticks, int temperature) {
        this.id = id;
        this.outputLeft = output;
        this.outputRight = secondOutput;
        this.inputLeft = inputLeft;
        this.inputRight = inputRight;
        this.secondaryChance = secondaryChance;
        this.ticks = ticks;
        this.temperature = temperature;
    }

    public boolean matches(@NotNull SimpleContainer container, Level level) {
        if (level.m_5776_()) {
            return false;
        }
        return this.inputLeft.test(container.m_8020_(0)) && this.inputRight.test(container.m_8020_(1));
    }

    @NotNull
    public ItemStack assemble(@Nullable SimpleContainer pContainer, @NotNull RegistryAccess pRegistryAccess) {
        return this.outputLeft;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@Nullable RegistryAccess pRegistryAccess) {
        return this.outputLeft.m_41777_();
    }

    public ItemStack getSecondaryResultItem() {
        return this.outputRight.m_41777_();
    }

    public int getSecondaryChance() {
        return this.secondaryChance;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.BLASTING_RECIPE_TYPE.get();
    }

    public int getTemperature() {
        return this.temperature;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.inputLeft, this.inputRight});
    }

    public int getTicks() {
        return this.ticks;
    }

    public static class Serializer
    implements RecipeSerializer<BlastingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("thoriumreactors", "blasting");

        @NotNull
        public BlastingRecipe fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject pSerializedRecipe) {
            Ingredient inputLeft = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"input").getAsJsonObject("slot-0"));
            if (inputLeft.m_43947_()) {
                throw new IllegalArgumentException("Invalid pattern: Input left ingredient must be set! (" + inputLeft + ")");
            }
            Ingredient inputRight = Ingredient.f_43901_;
            if (GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"input").has("slot-1") && (inputRight = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"input").getAsJsonObject("slot-1"))).m_43947_()) {
                throw new IllegalArgumentException("Invalid pattern: Input right ingredient must be set! (" + inputRight + ")");
            }
            ItemStack outputLeft = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output").getAsJsonObject("slot-0"));
            ItemStack outputRight = ItemStack.f_41583_;
            int secondaryChance = 0;
            if (GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output").has("slot-1")) {
                outputRight = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output").getAsJsonObject("slot-1"));
                secondaryChance = GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output").get("chance").getAsInt();
            }
            if (!outputRight.m_41619_() && secondaryChance == 0) {
                throw new IllegalArgumentException("Invalid pattern: Output right ingredient chance must be greater 0 and less or equal to 100 if ingredient is set! (" + secondaryChance + ")");
            }
            if (outputLeft.m_41619_()) {
                throw new IllegalArgumentException("Invalid pattern: Output left ingredient must be set! (" + outputLeft + ")");
            }
            int ticks = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"ticks");
            if (ticks <= 0 || ticks > 2500) {
                throw new IllegalArgumentException("Invalid pattern: Needed ticks cannot be zero or higher than 2500! (" + ticks + ")");
            }
            int temperature = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"temperature");
            if (temperature <= 0 || temperature > 2500) {
                throw new IllegalArgumentException("Invalid pattern: Needed temperature cannot be zero or higher than 2500! (" + ticks + ")");
            }
            return new BlastingRecipe(pRecipeId, inputLeft, inputRight, outputLeft, outputRight, secondaryChance, ticks, temperature);
        }

        @Nullable
        public BlastingRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            Ingredient inputLeft = Ingredient.m_43940_((FriendlyByteBuf)buf);
            Ingredient inputRight = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack outputLeft = buf.m_130267_();
            ItemStack outputRight = buf.m_130267_();
            int secondaryChance = buf.readInt();
            int ticks = buf.readInt();
            int temperature = buf.readInt();
            return new BlastingRecipe(id, inputLeft, inputRight, outputLeft, outputRight, secondaryChance, ticks, temperature);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, BlastingRecipe recipe) {
            recipe.inputLeft.m_43923_(buf);
            recipe.inputRight.m_43923_(buf);
            buf.m_130055_(recipe.outputLeft);
            buf.m_130055_(recipe.outputRight);
            buf.writeInt(recipe.secondaryChance);
            buf.writeInt(recipe.ticks);
            buf.writeInt(recipe.temperature);
        }
    }
}

