/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.network.toserver.reactor;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import unhappycodings.thoriumreactors.common.blockentity.reactor.ReactorControllerBlockEntity;
import unhappycodings.thoriumreactors.common.enums.ReactorStateEnum;
import unhappycodings.thoriumreactors.common.network.base.IPacket;

public class ReactorControllerStatePacket
implements IPacket {
    BlockPos pos;
    ReactorStateEnum state;

    public ReactorControllerStatePacket(BlockPos pos, ReactorStateEnum state) {
        this.pos = pos;
        this.state = state;
    }

    public static ReactorControllerStatePacket decode(FriendlyByteBuf buffer) {
        return new ReactorControllerStatePacket(buffer.m_130135_(), (ReactorStateEnum)buffer.m_130066_(ReactorStateEnum.class));
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        Level level = player.m_20193_();
        BlockEntity blockEntity = level.m_7702_(this.pos);
        if (blockEntity instanceof ReactorControllerBlockEntity) {
            ReactorControllerBlockEntity entity = (ReactorControllerBlockEntity)blockEntity;
            entity.setReactorState(this.state);
            if (this.state == ReactorStateEnum.STARTING && entity.getReactorRunningSince() == 0L) {
                entity.setReactorRunningSince(0L);
            } else if (this.state == ReactorStateEnum.STOP) {
                entity.setReactorRunningSince(-1L);
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130068_((Enum)this.state);
    }
}

