/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.network.toclient.turbine;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import unhappycodings.thoriumreactors.common.blockentity.turbine.TurbineControllerBlockEntity;
import unhappycodings.thoriumreactors.common.network.base.IPacket;

public class ClientTurbineControllerDataPacket
implements IPacket {
    private final BlockPos pos;
    public final boolean coilsEngaged;
    public final boolean activated;
    public final float flowrate;
    public final float currentFlowrate;
    public final float rpm;
    public final long turbinetime;

    public ClientTurbineControllerDataPacket(BlockPos pos, boolean coilsEngaged, boolean activated, float flowrate, float currentFlowrate, float rpm, long turbinetime) {
        this.coilsEngaged = coilsEngaged;
        this.activated = activated;
        this.pos = pos;
        this.flowrate = flowrate;
        this.currentFlowrate = currentFlowrate;
        this.rpm = rpm;
        this.turbinetime = turbinetime;
    }

    public static ClientTurbineControllerDataPacket decode(FriendlyByteBuf buffer) {
        return new ClientTurbineControllerDataPacket(buffer.m_130135_(), buffer.readBoolean(), buffer.readBoolean(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readLong());
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockEntity machine = player.m_9236_().m_7702_(this.pos);
        if (!(machine instanceof TurbineControllerBlockEntity)) {
            return;
        }
        TurbineControllerBlockEntity blockEntity = (TurbineControllerBlockEntity)machine;
        blockEntity.setCoilsEngaged(this.coilsEngaged);
        blockEntity.setActivated(this.activated);
        blockEntity.setTargetFlowrate(this.flowrate);
        blockEntity.setCurrentFlowrate(this.currentFlowrate);
        blockEntity.setRpm(this.rpm);
        blockEntity.setTurbinetime(this.turbinetime);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeBoolean(this.coilsEngaged);
        buffer.writeBoolean(this.activated);
        buffer.writeFloat(this.flowrate);
        buffer.writeFloat(this.currentFlowrate);
        buffer.writeFloat(this.rpm);
        buffer.writeLong(this.turbinetime);
    }
}

