/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.network.toclient.reactor;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import unhappycodings.thoriumreactors.common.blockentity.turbine.TurbineControllerBlockEntity;
import unhappycodings.thoriumreactors.common.network.base.IPacket;

public class TurbineFlowPacket
implements IPacket {
    private final BlockPos pos;
    private final byte flow;

    public TurbineFlowPacket(BlockPos pos, byte flow) {
        this.pos = pos;
        this.flow = flow;
    }

    public static TurbineFlowPacket decode(FriendlyByteBuf buffer) {
        return new TurbineFlowPacket(buffer.m_130135_(), buffer.readByte());
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        Level level = player.m_20193_();
        BlockEntity machine = level.m_7702_(this.pos);
        if (!(machine instanceof TurbineControllerBlockEntity)) {
            return;
        }
        TurbineControllerBlockEntity blockEntity = (TurbineControllerBlockEntity)machine;
        float finalValue = blockEntity.getTargetFlowrate() + (float)this.flow;
        if (finalValue >= 0.0f && finalValue <= 2500.0f) {
            blockEntity.setTargetFlowrate(finalValue);
            blockEntity.m_6596_();
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeByte((int)this.flow);
    }
}

