/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.network.toclient.reactor;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import unhappycodings.thoriumreactors.common.blockentity.reactor.ReactorControllerBlockEntity;
import unhappycodings.thoriumreactors.common.network.base.IPacket;

public class ReactorControllerRodInsertPacket
implements IPacket {
    private final BlockPos pos;
    private final byte rod;
    private final byte insert;
    private final boolean shiftDown;

    public ReactorControllerRodInsertPacket(BlockPos pos, byte insert, byte rod, boolean shiftDown) {
        this.pos = pos;
        this.insert = insert;
        this.rod = rod;
        this.shiftDown = shiftDown;
    }

    public static ReactorControllerRodInsertPacket decode(FriendlyByteBuf buffer) {
        return new ReactorControllerRodInsertPacket(buffer.m_130135_(), buffer.readByte(), buffer.readByte(), buffer.readBoolean());
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        Level level = player.m_20193_();
        BlockEntity machine = level.m_7702_(this.pos);
        if (!(machine instanceof ReactorControllerBlockEntity)) {
            return;
        }
        ReactorControllerBlockEntity blockEntity = (ReactorControllerBlockEntity)machine;
        if (this.shiftDown) {
            for (int i = 0; i < 64; ++i) {
                blockEntity.setTargetControlRodStatus((byte)i, this.insert);
            }
        } else {
            blockEntity.setTargetControlRodStatus(this.rod, this.insert);
        }
        blockEntity.m_6596_();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeByte((int)this.insert);
        buffer.writeByte((int)this.rod);
        buffer.writeBoolean(this.shiftDown);
    }
}

