/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.network.toclient.reactor;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;
import unhappycodings.thoriumreactors.common.blockentity.reactor.ReactorControllerBlockEntity;
import unhappycodings.thoriumreactors.common.enums.ReactorStateEnum;
import unhappycodings.thoriumreactors.common.network.base.IPacket;

public class ClientReactorControllerDataPacket
implements IPacket {
    private final BlockPos pos;
    private final float reactorTargetTemperature;
    private final float reactorCurrentTemperature;
    private final byte reactorTargetLoadSet;
    private final byte reactorCurrentLoadSet;
    private final long reactorRunningSince;
    private final float reactorStatus;
    private final float reactorContainment;
    private final float reactorRadiation;
    private final float reactorPressure;
    private final int reactorHeight;
    private final ReactorStateEnum reactorState;
    private final FluidStack fluidIn;
    private final FluidStack fluidOut;
    private final String notification;
    public boolean isReactorActive;
    public boolean isExchangerActive;
    public boolean isTurbineActive;
    public int reactorCapacity;
    public final byte[] fuelRodStatus;
    public final byte[] depletedfuelRodStatus;
    public final byte[] controlRodStatus;
    private final List<BlockPos> turbinePositions;
    private final byte turbineSpeed;
    private final byte turbineTargetFlow;
    private final byte turbineCurrentFlow;
    private final boolean turbineCoilsEngaged;
    private final boolean turbineActivated;
    private final long turbinePowerGeneration;

    public ClientReactorControllerDataPacket(BlockPos pos, float reactorTargetTemperature, float reactorCurrentTemperature, byte reactorTargetLoadSet, byte reactorCurrentLoadSet, long reactorRunningSince, float reactorStatus, float reactorContainment, float reactorRadiation, float reactorPressure, int reactorHeight, ReactorStateEnum reactorState, boolean turbineActivated, boolean turbineCoilsEngaged, byte turbineTargetFlow, byte turbineCurrentFlow, long turbinePowerGeneration, byte turbineSpeed, byte[] depletedfuelRodStatus, byte[] fuelRodStatus, byte[] controlRodStatus, FluidStack fluidIn, FluidStack fluidOut, String notification, boolean isReactorActive, boolean isTurbineActive, boolean isExchangerActive, int reactorCapacity, List<BlockPos> turbinePositions) {
        this.pos = pos;
        this.reactorTargetTemperature = reactorTargetTemperature;
        this.reactorCurrentTemperature = reactorCurrentTemperature;
        this.reactorTargetLoadSet = reactorTargetLoadSet;
        this.reactorCurrentLoadSet = reactorCurrentLoadSet;
        this.reactorRunningSince = reactorRunningSince;
        this.reactorStatus = reactorStatus;
        this.reactorContainment = reactorContainment;
        this.reactorRadiation = reactorRadiation;
        this.reactorPressure = reactorPressure;
        this.reactorHeight = reactorHeight;
        this.reactorState = reactorState;
        this.turbinePositions = turbinePositions;
        this.turbineSpeed = turbineSpeed;
        this.turbineActivated = turbineActivated;
        this.turbineCoilsEngaged = turbineCoilsEngaged;
        this.turbineCurrentFlow = turbineCurrentFlow;
        this.turbineTargetFlow = turbineTargetFlow;
        this.turbinePowerGeneration = turbinePowerGeneration;
        this.depletedfuelRodStatus = depletedfuelRodStatus;
        this.fuelRodStatus = fuelRodStatus;
        this.controlRodStatus = controlRodStatus;
        this.fluidIn = fluidIn;
        this.fluidOut = fluidOut;
        this.notification = notification;
        this.isReactorActive = isReactorActive;
        this.isTurbineActive = isTurbineActive;
        this.isExchangerActive = isExchangerActive;
        this.reactorCapacity = reactorCapacity;
    }

    public static ClientReactorControllerDataPacket decode(FriendlyByteBuf buffer) {
        return new ClientReactorControllerDataPacket(buffer.m_130135_(), buffer.readFloat(), buffer.readFloat(), buffer.readByte(), buffer.readByte(), buffer.readLong(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt(), (ReactorStateEnum)buffer.m_130066_(ReactorStateEnum.class), buffer.readBoolean(), buffer.readBoolean(), buffer.readByte(), buffer.readByte(), buffer.readLong(), buffer.readByte(), buffer.m_130052_(), buffer.m_130052_(), buffer.m_130052_(), buffer.readFluidStack(), buffer.readFluidStack(), buffer.m_130277_(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean(), buffer.readInt(), buffer.m_236845_(FriendlyByteBuf::m_130135_));
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockEntity machine = player.m_9236_().m_7702_(this.pos);
        if (!(machine instanceof ReactorControllerBlockEntity)) {
            return;
        }
        ReactorControllerBlockEntity blockEntity = (ReactorControllerBlockEntity)machine;
        blockEntity.setReactorTargetTemperature(this.reactorTargetTemperature);
        blockEntity.setReactorCurrentTemperature(this.reactorCurrentTemperature);
        blockEntity.setReactorTargetLoadSet(this.reactorTargetLoadSet);
        blockEntity.setReactorCurrentLoadSet(this.reactorCurrentLoadSet);
        blockEntity.setReactorRunningSince(this.reactorRunningSince);
        blockEntity.setReactorStatus(this.reactorStatus);
        blockEntity.setReactorContainment(this.reactorContainment);
        blockEntity.setReactorRadiation(this.reactorRadiation);
        blockEntity.setReactorPressure(this.reactorPressure);
        blockEntity.setReactorHeight(this.reactorHeight);
        blockEntity.setReactorState(this.reactorState);
        blockEntity.setDepletedFuelRodStatus(this.depletedfuelRodStatus);
        blockEntity.setFuelRodStatus(this.fuelRodStatus);
        blockEntity.setControlRodStatus(this.controlRodStatus);
        blockEntity.setTurbineActivated(this.turbineActivated);
        blockEntity.setTurbineCoilsEngaged(this.turbineCoilsEngaged);
        blockEntity.setTurbineTargetFlow(this.turbineTargetFlow);
        blockEntity.setTurbineCurrentFlow(this.turbineCurrentFlow);
        blockEntity.setTurbinePowerGeneration(this.turbinePowerGeneration);
        blockEntity.setTurbineSpeed(this.turbineSpeed);
        blockEntity.setFluidIn(this.fluidIn);
        blockEntity.setFluidOut(this.fluidOut);
        blockEntity.setNotification(this.notification);
        blockEntity.setReactorActive(this.isReactorActive);
        blockEntity.setTurbineActive(this.isTurbineActive);
        blockEntity.setExchangerActive(this.isExchangerActive);
        blockEntity.setReactorCapacity(this.reactorCapacity);
        blockEntity.setTurbinePos(this.turbinePositions);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeFloat(this.reactorTargetTemperature);
        buffer.writeFloat(this.reactorCurrentTemperature);
        buffer.writeByte((int)this.reactorTargetLoadSet);
        buffer.writeByte((int)this.reactorCurrentLoadSet);
        buffer.writeLong(this.reactorRunningSince);
        buffer.writeFloat(this.reactorStatus);
        buffer.writeFloat(this.reactorContainment);
        buffer.writeFloat(this.reactorRadiation);
        buffer.writeFloat(this.reactorPressure);
        buffer.writeInt(this.reactorHeight);
        buffer.m_130068_((Enum)this.reactorState);
        buffer.writeBoolean(this.turbineActivated);
        buffer.writeBoolean(this.turbineCoilsEngaged);
        buffer.writeByte((int)this.turbineTargetFlow);
        buffer.writeByte((int)this.turbineCurrentFlow);
        buffer.writeLong(this.turbinePowerGeneration);
        buffer.writeByte((int)this.turbineSpeed);
        buffer.m_130087_(this.depletedfuelRodStatus);
        buffer.m_130087_(this.fuelRodStatus);
        buffer.m_130087_(this.controlRodStatus);
        buffer.writeFluidStack(this.fluidIn);
        buffer.writeFluidStack(this.fluidOut);
        buffer.m_130070_(this.notification);
        buffer.writeBoolean(this.isReactorActive);
        buffer.writeBoolean(this.isTurbineActive);
        buffer.writeBoolean(this.isExchangerActive);
        buffer.writeInt(this.reactorCapacity);
        buffer.m_236828_(this.turbinePositions != null ? this.turbinePositions : new ArrayList(), FriendlyByteBuf::m_130064_);
    }
}

