/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.network.toclient.machine;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import unhappycodings.thoriumreactors.common.blockentity.machine.MachineElectrolyticSaltSeparatorBlockEntity;
import unhappycodings.thoriumreactors.common.network.base.IPacket;

public class ClientElectrolyticSaltSeparatorDataPacket
implements IPacket {
    private final BlockPos pos;
    private final int energy;
    private final int maxRecipeTime;
    private final int recipeTime;
    private final int fluidIn;
    private final int fluidOut;
    private final int redstoneMode;
    private final boolean powerable;
    private final String fluidTypeIn;
    private final String fluidTypeOut;

    public ClientElectrolyticSaltSeparatorDataPacket(BlockPos pos, int energy, int maxRecipeTime, int recipeTime, int fluidIn, int fluidOut, String fluidTypeIn, String fluidTypeOut, boolean powerable, int redstoneMode) {
        this.pos = pos;
        this.energy = energy;
        this.maxRecipeTime = maxRecipeTime;
        this.recipeTime = recipeTime;
        this.fluidIn = fluidIn;
        this.fluidOut = fluidOut;
        this.powerable = powerable;
        this.redstoneMode = redstoneMode;
        this.fluidTypeIn = fluidTypeIn;
        this.fluidTypeOut = fluidTypeOut;
    }

    public static ClientElectrolyticSaltSeparatorDataPacket decode(FriendlyByteBuf buffer) {
        return new ClientElectrolyticSaltSeparatorDataPacket(buffer.m_130135_(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.m_130277_(), buffer.m_130277_(), buffer.readBoolean(), buffer.readInt());
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockEntity machine = player.m_9236_().m_7702_(this.pos);
        if (!(machine instanceof MachineElectrolyticSaltSeparatorBlockEntity)) {
            return;
        }
        MachineElectrolyticSaltSeparatorBlockEntity blockEntity = (MachineElectrolyticSaltSeparatorBlockEntity)machine;
        blockEntity.setEnergy(this.energy);
        blockEntity.setMaxRecipeTime(this.maxRecipeTime);
        blockEntity.setRecipeTime(this.recipeTime);
        blockEntity.setFluidIn(new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(this.fluidTypeIn)), this.fluidIn));
        blockEntity.setFluidOut(new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(this.fluidTypeOut)), this.fluidOut));
        blockEntity.setPowerable(this.powerable);
        blockEntity.setRedstoneMode(this.redstoneMode);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeInt(this.energy);
        buffer.writeInt(this.maxRecipeTime);
        buffer.writeInt(this.recipeTime);
        buffer.writeInt(this.fluidIn);
        buffer.writeInt(this.fluidOut);
        buffer.m_130070_(this.fluidTypeIn);
        buffer.m_130070_(this.fluidTypeOut);
        buffer.writeBoolean(this.powerable);
        buffer.writeInt(this.redstoneMode);
    }
}

