/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.network;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import unhappycodings.thoriumreactors.common.network.base.IPacket;
import unhappycodings.thoriumreactors.common.network.toclient.machine.ClientBlastFurnaceDataPacket;
import unhappycodings.thoriumreactors.common.network.toclient.machine.ClientConcentratorDataPacket;
import unhappycodings.thoriumreactors.common.network.toclient.machine.ClientCrystallizerDataPacket;
import unhappycodings.thoriumreactors.common.network.toclient.machine.ClientDecomposerDataPacket;
import unhappycodings.thoriumreactors.common.network.toclient.machine.ClientElectrolyticSaltSeparatorDataPacket;
import unhappycodings.thoriumreactors.common.network.toclient.machine.ClientFluidCentrifugeDataPacket;
import unhappycodings.thoriumreactors.common.network.toclient.machine.ClientFluidEnricherDataPacket;
import unhappycodings.thoriumreactors.common.network.toclient.machine.ClientFluidEvaporatorDataPacket;
import unhappycodings.thoriumreactors.common.network.toclient.machine.ClientGeneratorDataPacket;
import unhappycodings.thoriumreactors.common.network.toclient.machine.ClientSaltMelterDataPacket;
import unhappycodings.thoriumreactors.common.network.toclient.machine.ClientUraniumOxidizerDataPacket;
import unhappycodings.thoriumreactors.common.network.toclient.machine.MachineClientDumpModePacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ClientEnergyTankRenderDataPacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ClientFluidTankRenderDataPacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ClientReactorControllerDataPacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ClientReactorParticleDataPacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ClientReactorRenderDataPacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ReactorControllerLoadPacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ReactorControllerRodInsertPacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ReactorControllerScramPacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ReactorControllerTemperaturePacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.ReactorOpenContainerPacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.TurbineActivePacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.TurbineCoilsPacket;
import unhappycodings.thoriumreactors.common.network.toclient.reactor.TurbineFlowPacket;
import unhappycodings.thoriumreactors.common.network.toclient.thermal.ClientThermalConversionsPacket;
import unhappycodings.thoriumreactors.common.network.toclient.turbine.ClientTurbineControllerDataPacket;
import unhappycodings.thoriumreactors.common.network.toserver.MachineChangedPacket;
import unhappycodings.thoriumreactors.common.network.toserver.MachineDumpModePacket;
import unhappycodings.thoriumreactors.common.network.toserver.MachinePowerablePacket;
import unhappycodings.thoriumreactors.common.network.toserver.MachineRedstoneModePacket;
import unhappycodings.thoriumreactors.common.network.toserver.reactor.ReactorControllerChangedPacket;
import unhappycodings.thoriumreactors.common.network.toserver.reactor.ReactorControllerCopyTurbinePacket;
import unhappycodings.thoriumreactors.common.network.toserver.reactor.ReactorControllerRemoveTurbinePacket;
import unhappycodings.thoriumreactors.common.network.toserver.reactor.ReactorControllerStatePacket;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = ModLoadingContext.get().getActiveContainer().getModInfo().getVersion().toString();
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("thoriumreactors", "main_channel"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
    private static int index = 0;

    public static void init() {
        PacketHandler.registerServerToClient(ClientElectrolyticSaltSeparatorDataPacket.class, ClientElectrolyticSaltSeparatorDataPacket::decode);
        PacketHandler.registerServerToClient(ClientFluidEvaporatorDataPacket.class, ClientFluidEvaporatorDataPacket::decode);
        PacketHandler.registerServerToClient(MachineClientDumpModePacket.class, MachineClientDumpModePacket::decode);
        PacketHandler.registerServerToClient(ClientSaltMelterDataPacket.class, ClientSaltMelterDataPacket::decode);
        PacketHandler.registerServerToClient(ClientGeneratorDataPacket.class, ClientGeneratorDataPacket::decode);
        PacketHandler.registerServerToClient(ClientConcentratorDataPacket.class, ClientConcentratorDataPacket::decode);
        PacketHandler.registerServerToClient(ClientDecomposerDataPacket.class, ClientDecomposerDataPacket::decode);
        PacketHandler.registerServerToClient(ClientUraniumOxidizerDataPacket.class, ClientUraniumOxidizerDataPacket::decode);
        PacketHandler.registerServerToClient(ClientFluidEnricherDataPacket.class, ClientFluidEnricherDataPacket::decode);
        PacketHandler.registerServerToClient(ClientFluidCentrifugeDataPacket.class, ClientFluidCentrifugeDataPacket::decode);
        PacketHandler.registerServerToClient(ClientCrystallizerDataPacket.class, ClientCrystallizerDataPacket::decode);
        PacketHandler.registerServerToClient(ClientBlastFurnaceDataPacket.class, ClientBlastFurnaceDataPacket::decode);
        PacketHandler.registerServerToClient(ClientReactorControllerDataPacket.class, ClientReactorControllerDataPacket::decode);
        PacketHandler.registerServerToClient(ClientReactorRenderDataPacket.class, ClientReactorRenderDataPacket::decode);
        PacketHandler.registerServerToClient(ClientEnergyTankRenderDataPacket.class, ClientEnergyTankRenderDataPacket::decode);
        PacketHandler.registerServerToClient(ClientFluidTankRenderDataPacket.class, ClientFluidTankRenderDataPacket::decode);
        PacketHandler.registerServerToClient(ClientReactorParticleDataPacket.class, ClientReactorParticleDataPacket::decode);
        PacketHandler.registerServerToClient(ClientTurbineControllerDataPacket.class, ClientTurbineControllerDataPacket::decode);
        PacketHandler.registerServerToClient(ClientThermalConversionsPacket.class, ClientThermalConversionsPacket::decode);
        PacketHandler.registerClientToServer(ReactorOpenContainerPacket.class, ReactorOpenContainerPacket::decode);
        PacketHandler.registerClientToServer(ReactorControllerScramPacket.class, ReactorControllerScramPacket::decode);
        PacketHandler.registerClientToServer(ReactorControllerRemoveTurbinePacket.class, ReactorControllerRemoveTurbinePacket::decode);
        PacketHandler.registerClientToServer(ReactorControllerCopyTurbinePacket.class, ReactorControllerCopyTurbinePacket::decode);
        PacketHandler.registerClientToServer(TurbineCoilsPacket.class, TurbineCoilsPacket::decode);
        PacketHandler.registerClientToServer(TurbineActivePacket.class, TurbineActivePacket::decode);
        PacketHandler.registerClientToServer(TurbineFlowPacket.class, TurbineFlowPacket::decode);
        PacketHandler.registerClientToServer(ReactorControllerRodInsertPacket.class, ReactorControllerRodInsertPacket::decode);
        PacketHandler.registerClientToServer(ReactorControllerLoadPacket.class, ReactorControllerLoadPacket::decode);
        PacketHandler.registerClientToServer(ReactorControllerTemperaturePacket.class, ReactorControllerTemperaturePacket::decode);
        PacketHandler.registerClientToServer(ReactorControllerStatePacket.class, ReactorControllerStatePacket::decode);
        PacketHandler.registerClientToServer(ReactorControllerChangedPacket.class, ReactorControllerChangedPacket::decode);
        PacketHandler.registerClientToServer(MachineRedstoneModePacket.class, MachineRedstoneModePacket::decode);
        PacketHandler.registerClientToServer(MachinePowerablePacket.class, MachinePowerablePacket::decode);
        PacketHandler.registerClientToServer(MachineDumpModePacket.class, MachineDumpModePacket::decode);
        PacketHandler.registerClientToServer(MachineChangedPacket.class, MachineChangedPacket::decode);
    }

    public static <MSG extends IPacket> void registerServerToClient(Class<MSG> packet, Function<FriendlyByteBuf, MSG> decode) {
        CHANNEL.registerMessage(index++, packet, IPacket::encode, decode, IPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static <MSG extends IPacket> void registerClientToServer(Class<MSG> packet, Function<FriendlyByteBuf, MSG> decode) {
        CHANNEL.registerMessage(index++, packet, IPacket::encode, decode, IPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public static void sendToClient(Object packet, ServerPlayer player) {
        CHANNEL.sendTo(packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToServer(Object packet) {
        CHANNEL.sendToServer(packet);
    }

    public static void sendTo(Object packet, ServerPlayer player) {
        if (!(player instanceof FakePlayer)) {
            CHANNEL.sendTo(packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

