/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.blockentity.reactor.ReactorControllerBlockEntity;
import unhappycodings.thoriumreactors.common.registration.ModBlocks;
import unhappycodings.thoriumreactors.common.util.FormattingUtil;

public class ConfiguratorItem
extends Item {
    public static final ToolAction WRENCH = ToolAction.get((String)"wrench");

    public ConfiguratorItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction == WRENCH;
    }

    @NotNull
    public Rarity m_41460_(@NotNull ItemStack pStack) {
        return Rarity.RARE;
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        Player player = context.m_43723_();
        ItemStack item = context.m_43722_();
        BlockPos pos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        if (context.m_43724_() != InteractionHand.MAIN_HAND) {
            return InteractionResult.CONSUME;
        }
        if (state.m_60713_((Block)ModBlocks.TURBINE_CONTROLLER_BLOCK.get())) {
            item = new ItemStack((ItemLike)item.m_41720_());
            CompoundTag posTag = new CompoundTag();
            ConfiguratorItem.writePos(posTag, pos);
            item.m_41784_().m_128365_("turbinePos", (Tag)posTag);
            player.m_5661_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("items.text.turbine_saved_to_configurator")).m_130948_(FormattingUtil.hex(8311637)), false);
        } else if (state.m_60713_((Block)ModBlocks.THERMAL_CONTROLLER.get())) {
            item = new ItemStack((ItemLike)item.m_41720_());
            CompoundTag posTag = new CompoundTag();
            ConfiguratorItem.writePos(posTag, pos);
            item.m_41784_().m_128365_("thermalPos", (Tag)posTag);
            player.m_5661_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("items.text.thermal_saved_to_configurator")).m_130948_(FormattingUtil.hex(8311637)), false);
        } else {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ReactorControllerBlockEntity) {
                ReactorControllerBlockEntity entity = (ReactorControllerBlockEntity)blockEntity;
                if (item.m_41784_().m_128441_("turbinePos")) {
                    entity.addTurbinePos(BlockEntity.m_187472_((CompoundTag)item.m_41784_().m_128469_("turbinePos")));
                    player.m_5661_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("items.text.turbine_saved_to_reactor")).m_130948_(FormattingUtil.hex(5624714)), false);
                }
                if (item.m_41784_().m_128441_("thermalPos")) {
                    entity.setThermalPos(BlockEntity.m_187472_((CompoundTag)item.m_41784_().m_128469_("thermalPos")));
                    player.m_5661_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("items.text.thermal_saved_to_reactor")).m_130948_(FormattingUtil.hex(5624714)), false);
                }
            }
        }
        player.m_8061_(EquipmentSlot.MAINHAND, item);
        return InteractionResult.FAIL;
    }

    public static void writePos(CompoundTag nbt, BlockPos pos) {
        nbt.m_128405_("x", pos.m_123341_());
        nbt.m_128405_("y", pos.m_123342_());
        nbt.m_128405_("z", pos.m_123343_());
    }

    public static BlockPos readPos(CompoundTag nbt) {
        BlockPos pos = new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
        return pos;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        String pos;
        if (stack.m_41784_().m_128441_("turbinePos")) {
            pos = stack.m_41784_().m_128423_("turbinePos").m_7916_().replace("{", "").replace("}", "").replace(",", " ");
            tooltipComponents.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("items.text.turbine_selected")).m_7220_((Component)Component.m_237113_((String)pos).m_130940_(ChatFormatting.GRAY)).m_130948_(FormattingUtil.hex(5624714)));
        }
        if (stack.m_41784_().m_128441_("thermalPos")) {
            pos = stack.m_41784_().m_128423_("thermalPos").m_7916_().replace("{", "").replace("}", "").replace(",", " ");
            tooltipComponents.add((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("items.text.thermal_selected")).m_7220_((Component)Component.m_237113_((String)pos).m_130940_(ChatFormatting.GRAY)).m_130948_(FormattingUtil.hex(5624714)));
        }
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }
}

