/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.integration;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unhappycodings.thoriumreactors.common.blockentity.reactor.ReactorCasingBlockEntity;
import unhappycodings.thoriumreactors.common.blockentity.reactor.ReactorControllerBlockEntity;
import unhappycodings.thoriumreactors.common.blockentity.turbine.TurbineControllerBlockEntity;
import unhappycodings.thoriumreactors.common.enums.ReactorStateEnum;
import unhappycodings.thoriumreactors.common.util.LuaUtil;

public class CCReactorPeripheral
implements IPeripheral {
    private final List<IComputerAccess> connectedComputers = new ArrayList<IComputerAccess>();
    private final ReactorCasingBlockEntity tileEntity;

    public CCReactorPeripheral(ReactorCasingBlockEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    @NotNull
    public String getType() {
        return "thorium_reactor";
    }

    public boolean equals(@Nullable IPeripheral iPeripheral) {
        return this == iPeripheral;
    }

    public void detach(@NotNull IComputerAccess computer) {
        this.connectedComputers.remove(computer);
    }

    public void attach(@NotNull IComputerAccess computer) {
        this.connectedComputers.add(computer);
    }

    public ReactorCasingBlockEntity getTileEntity() {
        return this.tileEntity;
    }

    @LuaFunction(mainThread=true)
    public final boolean isAssembled() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        return entity != null && entity.isAssembled();
    }

    @LuaFunction(mainThread=true)
    public final String getReactorState() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        return entity == null ? "undefined" : entity.getReactorState().m_7912_();
    }

    @LuaFunction(mainThread=true)
    public final void setReactorState(String status) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return;
        }
        entity.setReactorState(ReactorStateEnum.get(status));
    }

    @LuaFunction(mainThread=true)
    public final Integer getReactorFluidAmountOut() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        return entity == null ? -1 : entity.getFluidAmountOut();
    }

    @LuaFunction(mainThread=true)
    public final Integer getReactorFluidCapacityOut() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        return entity == null ? -1 : entity.getFluidCapacityOut();
    }

    @LuaFunction(mainThread=true)
    public final Integer getReactorFluidAmountIn() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        return entity == null ? -1 : entity.getFluidAmountIn();
    }

    @LuaFunction(mainThread=true)
    public final Integer getReactorFluidCapacityIn() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        return entity == null ? -1 : entity.getFluidCapacityIn();
    }

    @LuaFunction(mainThread=true)
    public final Integer getReactorCapacity() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        return entity == null ? -1 : entity.getReactorCapacity();
    }

    @LuaFunction(mainThread=true)
    public final Float getReactorCurrentLoadSet() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return Float.valueOf(-1.0f);
        }
        int fuelValue = 0;
        if (entity.getFuelRodStatus().length != 0) {
            for (int i = 0; i < entity.getFuelRodStatus().length; ++i) {
                fuelValue += entity.getFuelRodStatus()[i];
            }
        }
        return Float.valueOf((float)fuelValue / 8100.0f * 100.0f);
    }

    @LuaFunction(mainThread=true)
    public final Byte getReactorTargetLoadSet() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        return entity == null ? (byte)-1 : (byte)entity.getReactorTargetLoadSet();
    }

    @LuaFunction(mainThread=true)
    public final void setReactorTargetLoadSet(int rate) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null || rate < 0 || rate > 100) {
            return;
        }
        entity.setReactorTargetLoadSet((byte)rate);
    }

    @LuaFunction(mainThread=true)
    public final Float getReactorStatusPercent() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        return Float.valueOf(entity == null ? -1.0f : entity.getReactorStatus());
    }

    @LuaFunction(mainThread=true)
    public final Float getReactorContainmentPercent() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        return Float.valueOf(entity == null ? -1.0f : entity.getReactorContainment());
    }

    @LuaFunction(mainThread=true)
    public final Float getReactorRadiation() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        return Float.valueOf(entity == null ? -1.0f : entity.getReactorRadiation());
    }

    @LuaFunction(mainThread=true)
    public final boolean isReactorScrammed() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        return entity != null && entity.isScrammed();
    }

    @LuaFunction(mainThread=true)
    public final void setReactorScrammed(boolean state) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return;
        }
        entity.setScrammed(state);
    }

    @LuaFunction(mainThread=true)
    public final Long getReactorRunningSince() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        return entity == null ? -1L : entity.getReactorRunningSince();
    }

    @LuaFunction(mainThread=true)
    public final Float getReactorCurrentTemperature() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        return Float.valueOf(entity == null ? -1.0f : entity.getReactorCurrentTemperature());
    }

    @LuaFunction(mainThread=true)
    public final Float getReactorTargetTemperature() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        return Float.valueOf(entity == null ? -1.0f : entity.getReactorTargetTemperature());
    }

    @LuaFunction(mainThread=true)
    public final String getReactorNotification() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        return entity == null ? "undefined" : entity.getNotification();
    }

    @LuaFunction(mainThread=true)
    public final float getReactorLoad() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        return entity == null ? -1.0f : (entity.getReactorCurrentTemperature() - 22.0f) / 949.0f * 100.0f;
    }

    @LuaFunction(mainThread=true)
    public final float getFuelRodStatus(int index) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null || index < 0 || index > 80) {
            return -1.0f;
        }
        return entity.getFuelRodStatus((byte)index);
    }

    @LuaFunction(mainThread=true)
    public final Object getFuelRodStatusMap() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return new ArrayList();
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(81);
        for (int i = 0; i < 81; ++i) {
            map.put(i + 1, Integer.valueOf(entity.getFuelRodStatus((byte)i)));
        }
        return map;
    }

    @LuaFunction(mainThread=true)
    public final float getDepletedFuelRodStatus(int index) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null || index < 0 || index > 80) {
            return -1.0f;
        }
        return entity.getDepletedFuelRodStatus((byte)index);
    }

    @LuaFunction(mainThread=true)
    public final Object getDepletedFuelRodStatusMap() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return new ArrayList();
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(81);
        for (int i = 0; i < 81; ++i) {
            map.put(i + 1, Integer.valueOf(entity.getDepletedFuelRodStatus((byte)i)));
        }
        return map;
    }

    @LuaFunction(mainThread=true)
    public final float getCurrentControlRodStatus(int index) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null || index < 0 || index > 63) {
            return -1.0f;
        }
        return entity.getControlRodStatus((byte)index);
    }

    @LuaFunction(mainThread=true)
    public final Object getCurrentControlRodStatusMap() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return new ArrayList();
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(64);
        for (int i = 0; i < 64; ++i) {
            map.put(i + 1, entity.getControlRodStatus((byte)i));
        }
        return map;
    }

    @LuaFunction(mainThread=true)
    public final float getTargetControlRodStatus(int index) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null || index < 0 || index > 63) {
            return -1.0f;
        }
        return entity.getTargetControlRodStatus((byte)index);
    }

    @LuaFunction(mainThread=true)
    public final Object getTargetControlRodStatusMap() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return new ArrayList();
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(64);
        for (int i = 0; i < 64; ++i) {
            map.put(i + 1, Integer.valueOf(entity.getTargetControlRodStatus((byte)i)));
        }
        return map;
    }

    @LuaFunction(mainThread=true)
    public final void setTargetControlRodStatus(int index, int value) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null || index < 0 || index > 63 || value < 0 || value > 100) {
            return;
        }
        entity.setTargetControlRodStatus((byte)index, (byte)value);
    }

    @LuaFunction(mainThread=true)
    public final boolean isTurbineActive(int id) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return false;
        }
        BlockEntity blockEntity = entity.m_58904_().m_7702_(entity.getTurbinePos().get(id));
        if (blockEntity instanceof TurbineControllerBlockEntity) {
            TurbineControllerBlockEntity controllerBlockEntity = (TurbineControllerBlockEntity)blockEntity;
            return controllerBlockEntity.isActivated();
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final void setTurbineActive(int id, boolean state) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return;
        }
        BlockEntity blockEntity = entity.m_58904_().m_7702_(entity.getTurbinePos().get(id));
        if (blockEntity instanceof TurbineControllerBlockEntity) {
            TurbineControllerBlockEntity controllerBlockEntity = (TurbineControllerBlockEntity)blockEntity;
            controllerBlockEntity.setActivated(state);
        }
    }

    @LuaFunction(mainThread=true)
    public final boolean isTurbineCoilsEngaged(int id) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return false;
        }
        BlockEntity blockEntity = entity.m_58904_().m_7702_(entity.getTurbinePos().get(id));
        if (blockEntity instanceof TurbineControllerBlockEntity) {
            TurbineControllerBlockEntity controllerBlockEntity = (TurbineControllerBlockEntity)blockEntity;
            return controllerBlockEntity.isCoilsEngaged();
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final void setTurbineCoilsEngaged(int id, boolean state) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return;
        }
        BlockEntity blockEntity = entity.m_58904_().m_7702_(entity.getTurbinePos().get(id));
        if (blockEntity instanceof TurbineControllerBlockEntity) {
            TurbineControllerBlockEntity controllerBlockEntity = (TurbineControllerBlockEntity)blockEntity;
            controllerBlockEntity.setCoilsEngaged(state);
        }
    }

    @LuaFunction(mainThread=true)
    public final void copyConfigurationToAllTurbines(int id) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return;
        }
        BlockEntity blockEntity = entity.m_58904_().m_7702_(entity.getTurbinePos().get(id));
        if (blockEntity instanceof TurbineControllerBlockEntity) {
            TurbineControllerBlockEntity controllerBlockEntity = (TurbineControllerBlockEntity)blockEntity;
            float flowrate = controllerBlockEntity.getTargetFlowrate();
            boolean engaged = controllerBlockEntity.isCoilsEngaged();
            boolean activated = controllerBlockEntity.isActivated();
            for (BlockPos turbinePos : entity.getTurbinePos()) {
                BlockEntity blockEntity2 = controllerBlockEntity.m_58904_().m_7702_(turbinePos);
                if (!(blockEntity2 instanceof TurbineControllerBlockEntity)) continue;
                TurbineControllerBlockEntity targetEntity = (TurbineControllerBlockEntity)blockEntity2;
                targetEntity.setTargetFlowrate(flowrate);
                targetEntity.setActivated(activated);
                targetEntity.setCoilsEngaged(engaged);
            }
        }
    }

    @LuaFunction(mainThread=true)
    public final boolean isTurbineAssembled(int id) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return false;
        }
        TurbineControllerBlockEntity turbineEntity = this.getTurbineController(id);
        if (turbineEntity != null) {
            return turbineEntity.isAssembled();
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public final Integer getTurbineHeight(int id) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return -1;
        }
        TurbineControllerBlockEntity turbineEntity = this.getTurbineController(id);
        if (turbineEntity != null) {
            return turbineEntity.getTurbineHeight() + 1;
        }
        return -1;
    }

    @LuaFunction(mainThread=true)
    public final Float getTurbineCurrentFlow(int id) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return Float.valueOf(-1.0f);
        }
        TurbineControllerBlockEntity turbineEntity = this.getTurbineController(id);
        if (turbineEntity != null) {
            return Float.valueOf(turbineEntity.getCurrentFlowrate());
        }
        return Float.valueOf(-1.0f);
    }

    @LuaFunction(mainThread=true)
    public final Float getTurbineTargetFlow(int id) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return Float.valueOf(-1.0f);
        }
        TurbineControllerBlockEntity turbineEntity = this.getTurbineController(id);
        if (turbineEntity != null) {
            return Float.valueOf(turbineEntity.getTargetFlowrate());
        }
        return Float.valueOf(-1.0f);
    }

    @LuaFunction(mainThread=true)
    public final void setTurbineTargetFlow(int id, int flowrate) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return;
        }
        TurbineControllerBlockEntity turbineEntity = this.getTurbineController(id);
        if (turbineEntity != null) {
            turbineEntity.setTargetFlowrate(flowrate);
        }
    }

    @LuaFunction(mainThread=true)
    public final Float getTurbineGeneration(int id) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return Float.valueOf(-1.0f);
        }
        TurbineControllerBlockEntity turbineEntity = this.getTurbineController(id);
        if (turbineEntity != null) {
            return Float.valueOf(turbineEntity.getTurbineGeneration());
        }
        return Float.valueOf(-1.0f);
    }

    @LuaFunction(mainThread=true)
    public final Float getTurbineSpeed(int id) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return Float.valueOf(-1.0f);
        }
        TurbineControllerBlockEntity turbineEntity = this.getTurbineController(id);
        if (turbineEntity != null) {
            return Float.valueOf(turbineEntity.getRpm());
        }
        return Float.valueOf(-1.0f);
    }

    @LuaFunction(mainThread=true)
    public final Float getTurbineEnergyModifier(int id) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return Float.valueOf(-1.0f);
        }
        TurbineControllerBlockEntity turbineEntity = this.getTurbineController(id);
        if (turbineEntity != null) {
            return Float.valueOf(turbineEntity.getEnergyModifier());
        }
        return Float.valueOf(-1.0f);
    }

    @LuaFunction(mainThread=true)
    public final Object getTurbinePosition(int id) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return new ArrayList();
        }
        TurbineControllerBlockEntity turbineEntity = this.getTurbineController(id);
        if (turbineEntity != null) {
            return LuaUtil.posToObject(turbineEntity.m_58899_());
        }
        return null;
    }

    @LuaFunction(mainThread=true)
    public final String getTurbinePositionString(int id) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return "undefined";
        }
        TurbineControllerBlockEntity turbineEntity = this.getTurbineController(id);
        if (turbineEntity != null) {
            return turbineEntity.m_58899_().toString().replace("BlockPos{", "").replace("}", "");
        }
        return "undefined";
    }

    @LuaFunction(mainThread=true)
    public final List<Object> getTurbinePositions() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        if (entity == null) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> turbines = new ArrayList<Object>();
        for (int index = 0; index <= entity.getTurbinePos().size() - 1; ++index) {
            BlockPos turbinePos = entity.getTurbinePos().get(index);
            turbines.add(LuaUtil.turbineToObject(turbinePos, index));
        }
        return turbines;
    }

    @LuaFunction(mainThread=true)
    public final Integer getTurbineCount() {
        ReactorControllerBlockEntity entity = this.getReactorController();
        return entity == null ? -1 : entity.getTurbinePos().size();
    }

    private ReactorControllerBlockEntity getReactorController() {
        BlockEntity blockEntity = this.tileEntity.m_58904_().m_7702_(this.tileEntity.getControllerPos());
        if (blockEntity instanceof ReactorControllerBlockEntity) {
            ReactorControllerBlockEntity reactorTileEntity = (ReactorControllerBlockEntity)blockEntity;
            return reactorTileEntity;
        }
        return null;
    }

    private TurbineControllerBlockEntity getTurbineController(int id) {
        ReactorControllerBlockEntity entity = this.getReactorController();
        BlockEntity blockEntity = entity.m_58904_().m_7702_(entity.getTurbinePos().get(id));
        if (blockEntity instanceof TurbineControllerBlockEntity) {
            TurbineControllerBlockEntity controllerBlockEntity = (TurbineControllerBlockEntity)blockEntity;
            return controllerBlockEntity;
        }
        return null;
    }
}

