/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.fluid;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundAction;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import unhappycodings.thoriumreactors.common.registration.Registration;

public class ModFluidTypes {
    public static final ResourceLocation WATER_STILL_RL = new ResourceLocation("block/water_still");
    public static final ResourceLocation WATER_FLOWING_RL = new ResourceLocation("block/water_flow");
    public static final ResourceLocation SOAP_OVERLAY_RL = new ResourceLocation("thoriumreactors", "misc/in_molten_salt");
    public static final RegistryObject<FluidType> MOLTEN_SALT = Registration.FLUID_TYPES.register("molten_salt", ModFluidTypes::getMoltenSaltFluidType);
    public static final RegistryObject<FluidType> DEPLETED_MOLTEN_SALT = Registration.FLUID_TYPES.register("depleted_molten_salt", ModFluidTypes::getMoltenSaltFluidType);
    public static final RegistryObject<FluidType> HEATED_MOLTEN_SALT = Registration.FLUID_TYPES.register("heated_molten_salt", () -> new FluidType(FluidType.Properties.create().density(6000).viscosity(12000).temperature(460).motionScale(0.0023333333333333335)){

        public double motionScale(Entity entity) {
            return 6.666666666666668E-4;
        }

        public boolean canDrownIn(LivingEntity entity) {
            return false;
        }

        public boolean canHydrate(Entity entity) {
            return false;
        }

        @Nullable
        public SoundEvent getSound(SoundAction action) {
            return action.name() == "bucket_empty" ? SoundEvents.f_11778_ : SoundEvents.f_11781_;
        }

        public void setItemMovement(ItemEntity entity) {
            Vec3 vec3 = entity.m_20184_();
            entity.m_20334_(vec3.f_82479_ * (double)0.95f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.95f);
        }

        public float getFallDistanceModifier(Entity entity) {
            return Fluids.f_76195_.getFluidType().getFallDistanceModifier(entity);
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private static final ResourceLocation WATER_STILL = new ResourceLocation("block/water_still");
                private static final ResourceLocation WATER_FLOW = new ResourceLocation("block/water_flow");

                public ResourceLocation getStillTexture() {
                    return WATER_STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return WATER_FLOW;
                }

                public int getTintColor() {
                    return -427785640;
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    return new Vector3f(0.54901963f, 0.5568628f, 0.41568628f);
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    RenderSystem.setShaderFogStart((float)0.0f);
                    RenderSystem.setShaderFogEnd((float)1.0f);
                }
            });
        }
    });
    public static final RegistryObject<FluidType> HYDROFLUORITE = Registration.FLUID_TYPES.register("hydrofluorite", () -> new FluidType(FluidType.Properties.create()){

        public boolean canDrownIn(LivingEntity entity) {
            return true;
        }

        public boolean canHydrate(Entity entity) {
            return true;
        }

        @Nullable
        public SoundEvent getSound(SoundAction action) {
            return action.name() == "bucket_empty" ? SoundEvents.f_11778_ : SoundEvents.f_11781_;
        }

        public float getFallDistanceModifier(Entity entity) {
            return Fluids.f_76193_.getFluidType().getFallDistanceModifier(entity);
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private static final ResourceLocation WATER_STILL = new ResourceLocation("block/water_still");
                private static final ResourceLocation WATER_FLOW = new ResourceLocation("block/water_flow");

                public ResourceLocation getStillTexture() {
                    return WATER_STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return WATER_FLOW;
                }

                public int getTintColor() {
                    return -431778344;
                }
            });
        }
    });
    public static final RegistryObject<FluidType> STEAM = Registration.FLUID_TYPES.register("steam", () -> new FluidType(FluidType.Properties.create()){

        public boolean canDrownIn(LivingEntity entity) {
            return true;
        }

        public boolean canHydrate(Entity entity) {
            return true;
        }

        @Nullable
        public SoundEvent getSound(SoundAction action) {
            return action.name() == "bucket_empty" ? SoundEvents.f_11778_ : SoundEvents.f_11781_;
        }

        public float getFallDistanceModifier(Entity entity) {
            return Fluids.f_76193_.getFluidType().getFallDistanceModifier(entity);
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private static final ResourceLocation WATER_STILL = new ResourceLocation("block/water_still");
                private static final ResourceLocation WATER_FLOW = new ResourceLocation("block/water_flow");

                public ResourceLocation getStillTexture() {
                    return WATER_STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return WATER_FLOW;
                }

                public int getTintColor() {
                    return -424035911;
                }
            });
        }
    });
    public static final RegistryObject<FluidType> URANIUM_HEXAFLUORITE = Registration.FLUID_TYPES.register("uranium_hexafluorite", () -> new FluidType(FluidType.Properties.create()){

        public boolean canDrownIn(LivingEntity entity) {
            return true;
        }

        public boolean canHydrate(Entity entity) {
            return true;
        }

        @Nullable
        public SoundEvent getSound(SoundAction action) {
            return action.name() == "bucket_empty" ? SoundEvents.f_11778_ : SoundEvents.f_11781_;
        }

        public float getFallDistanceModifier(Entity entity) {
            return Fluids.f_76193_.getFluidType().getFallDistanceModifier(entity);
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private static final ResourceLocation WATER_STILL = new ResourceLocation("block/water_still");
                private static final ResourceLocation WATER_FLOW = new ResourceLocation("block/water_flow");

                public ResourceLocation getStillTexture() {
                    return WATER_STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return WATER_FLOW;
                }

                public int getTintColor() {
                    return -432449724;
                }
            });
        }
    });
    public static final RegistryObject<FluidType> ENRICHED_URANIUM_HEXAFLUORITE = Registration.FLUID_TYPES.register("enriched_uranium_hexafluorite", () -> new FluidType(FluidType.Properties.create()){

        public boolean canDrownIn(LivingEntity entity) {
            return true;
        }

        public boolean canHydrate(Entity entity) {
            return true;
        }

        @Nullable
        public SoundEvent getSound(SoundAction action) {
            return action.name() == "bucket_empty" ? SoundEvents.f_11778_ : SoundEvents.f_11781_;
        }

        public float getFallDistanceModifier(Entity entity) {
            return Fluids.f_76193_.getFluidType().getFallDistanceModifier(entity);
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private static final ResourceLocation WATER_STILL = new ResourceLocation("block/water_still");
                private static final ResourceLocation WATER_FLOW = new ResourceLocation("block/water_flow");

                public ResourceLocation getStillTexture() {
                    return WATER_STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return WATER_FLOW;
                }

                public int getTintColor() {
                    return -432445884;
                }
            });
        }
    });

    private static FluidType getMoltenSaltFluidType() {
        return new FluidType(FluidType.Properties.create().density(3000).viscosity(6000).temperature(140).motionScale(0.0023333333333333335)){

            public double motionScale(Entity entity) {
                return 0.0013333333333333335;
            }

            public boolean canDrownIn(LivingEntity entity) {
                return false;
            }

            public boolean canHydrate(Entity entity) {
                return false;
            }

            @Nullable
            public SoundEvent getSound(SoundAction action) {
                return action.name() == "bucket_empty" ? SoundEvents.f_11778_ : SoundEvents.f_11781_;
            }

            public void setItemMovement(ItemEntity entity) {
                Vec3 vec3 = entity.m_20184_();
                entity.m_20334_(vec3.f_82479_ * (double)0.95f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.95f);
            }

            public float getFallDistanceModifier(Entity entity) {
                return Fluids.f_76195_.getFluidType().getFallDistanceModifier(entity);
            }

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){
                    private static final ResourceLocation WATER_STILL = new ResourceLocation("block/water_still");
                    private static final ResourceLocation WATER_FLOW = new ResourceLocation("block/water_flow");

                    public ResourceLocation getStillTexture() {
                        return WATER_STILL;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return WATER_FLOW;
                    }

                    public int getTintColor() {
                        return -426996118;
                    }

                    @NotNull
                    public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                        return new Vector3f(0.54901963f, 0.5568628f, 0.41568628f);
                    }

                    public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                        RenderSystem.setShaderFogStart((float)0.0f);
                        RenderSystem.setShaderFogEnd((float)1.0f);
                    }
                });
            }
        };
    }
}

