/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.energy;

import net.minecraft.core.Direction;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import unhappycodings.thoriumreactors.common.energy.IEnergyCapable;

public class EnergyHandler
extends EnergyStorage {
    public IEnergyCapable energyHandler;
    public Direction direction;

    public EnergyHandler(IEnergyCapable energyHandler, Direction direction) {
        super((int)energyHandler.getEnergyCapacity(), (int)energyHandler.getMaxEnergyTransfer());
        this.energyHandler = energyHandler;
        this.direction = direction;
    }

    public static LazyOptional<EnergyHandler>[] createEnergyHandlers(IEnergyCapable handler, Direction ... directions) {
        LazyOptional[] handlers = new LazyOptional[directions.length];
        for (int i = 0; i < directions.length; ++i) {
            Direction side = directions[i];
            handlers[i] = LazyOptional.of(() -> new EnergyHandler(handler, side));
        }
        return handlers;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        long energyReceived = Math.min((long)(this.getMaxEnergyStored() - this.getEnergyStored()), Math.min(this.energyHandler.getMaxEnergyTransfer(), (long)maxReceive));
        if (!simulate) {
            this.energyHandler.addEnergy(energyReceived, false);
        }
        return (int)energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        long energyExtracted = Math.min((long)this.getEnergyStored(), Math.min(this.energyHandler.getMaxEnergyTransfer(), (long)maxExtract));
        if (!simulate) {
            this.energyHandler.removeEnergy(energyExtracted, false);
        }
        return (int)energyExtracted;
    }

    public int getEnergyStored() {
        return (int)this.energyHandler.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return (int)this.energyHandler.getEnergyCapacity();
    }

    public boolean canExtract() {
        return this.energyHandler.canOutputEnergy(this.direction);
    }

    public boolean canReceive() {
        return this.energyHandler.canInputEnergy(this.direction);
    }
}

