/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.container.tank;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;
import unhappycodings.thoriumreactors.client.util.RenderUtil;
import unhappycodings.thoriumreactors.common.blockentity.tank.FluidTankBlockEntity;
import unhappycodings.thoriumreactors.common.container.base.screen.BaseScreen;
import unhappycodings.thoriumreactors.common.container.tank.FluidTankContainer;
import unhappycodings.thoriumreactors.common.util.FormattingUtil;
import unhappycodings.thoriumreactors.common.util.ScreenUtil;

public class FluidTankScreen
extends BaseScreen<FluidTankContainer> {
    private final FluidTankContainer container;

    public FluidTankScreen(FluidTankContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.container = screenContainer;
    }

    @Override
    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTicks, int x, int y) {
        super.m_7286_(graphics, partialTicks, x, y);
        FluidTankBlockEntity entity = this.container.getTile();
        RenderUtil.renderFluid(this.getGuiLeft() + 15, this.getGuiTop() + 97, 76, 16, entity.getFluidAmountIn(), entity.getFluidCapacityIn(), entity.getFluidIn().getFluid());
        RenderUtil.renderFluid(this.getGuiLeft() + 31, this.getGuiTop() + 97, 76, 16, entity.getFluidAmountIn(), entity.getFluidCapacityIn(), entity.getFluidIn().getFluid());
        RenderUtil.renderFluid(this.getGuiLeft() + 47, this.getGuiTop() + 97, 76, 2, entity.getFluidAmountIn(), entity.getFluidCapacityIn(), entity.getFluidIn().getFluid());
        RenderUtil.resetGuiTextures(this.getTexture());
        graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 16, this.getGuiTop() + 22, 176, 0, 4, 75);
    }

    protected void m_280003_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY) {
        FluidTankBlockEntity entity = this.container.getTile();
        PoseStack pPoseStack = graphics.m_280168_();
        ScreenUtil.drawText(Component.m_237115_((String)"key.categories.inventory").m_130938_(ScreenUtil::notoSans), graphics, 8, 102, 0xAAAAAA);
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.7f, 0.7f, 0.7f);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("machines.fluid_tank.name")).m_130938_(ScreenUtil::notoSans), graphics, 10, 2, 0xAAAAAA);
        ScreenUtil.drawRightboundText(Component.m_237113_((String)Minecraft.m_91087_().f_91074_.m_6302_()).m_130938_(ScreenUtil::notoSans), graphics, 242, 2, 0xAAAAAA);
        MutableComponent amount = entity.getFluidAmountIn() == Integer.MAX_VALUE ? Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.infinite"))) : Component.m_237113_((String)(" " + entity.getFluidAmountIn() + "mB"));
        MutableComponent capacity = entity.getFluidCapacityIn() == Integer.MAX_VALUE ? Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.infinite"))) : Component.m_237113_((String)(" " + entity.getFluidCapacityIn() + "mB"));
        pPoseStack.m_85849_();
        int textLenght = Minecraft.m_91087_().f_91062_.m_92895_(entity.getFluidIn().getFluid().getFluidType().getDescription().getString());
        float textSize = textLenght > 100 ? 0.7f : 0.8f;
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(textSize, textSize, textSize);
        ScreenUtil.drawCenteredText(Component.m_237113_((String)entity.getFluidIn().getFluid().getFluidType().getDescription().getString()).m_130948_(FormattingUtil.hex(5624714).m_131162_(Boolean.valueOf(true))).m_130938_(ScreenUtil::notoSans), graphics, textLenght < 100 ? 145 : 165, textLenght < 100 ? 28 : 32);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.8f, 0.8f, 0.8f);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("machines.text.amount")).m_130948_(FormattingUtil.hex(708302)).m_7220_((Component)amount.m_130940_(ChatFormatting.GRAY)).m_130938_(ScreenUtil::notoSans), graphics, 90, 46);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("machines.text.capacity")).m_130948_(FormattingUtil.hex(13028414)).m_7220_((Component)capacity.m_130940_(ChatFormatting.GRAY)).m_130938_(ScreenUtil::notoSans), graphics, 90, 56);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("machines.text.fillage")).m_130948_(FormattingUtil.hex(8311637)).m_7220_((Component)Component.m_237113_((String)(" " + FormattingUtil.formatPercentNum(entity.getFluidAmountIn(), entity.getFluidCapacityIn(), true))).m_130940_(ChatFormatting.GRAY)).m_130938_(ScreenUtil::notoSans), graphics, 90, 66);
        pPoseStack.m_85849_();
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + 16, this.getGuiTop() + 21, this.getGuiLeft() + 49, this.getGuiTop() + 97, pMouseX, pMouseY)) {
            this.appendHoverText(graphics, pMouseX, pMouseY, new Component[]{entity.getFluidAmountIn() > 0 ? Component.m_237115_((String)FormattingUtil.getTranslatable("machines.tooltip.fluid")).m_130946_(" ").m_130946_(entity.getFluidIn().getFluid().getFluidType().getDescription().getString()) : Component.m_237119_(), Component.m_237113_((String)(entity.getFluidAmountIn() + " mB / " + entity.getFluidCapacityIn() + " mB")), Component.m_237113_((String)FormattingUtil.formatPercentNum(entity.getFluidAmountIn(), entity.getFluidCapacityIn(), true))});
        }
    }

    public void appendHoverText(GuiGraphics graphics, int x, int y, String[] texts) {
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        for (String text : texts) {
            if (text.equals("")) continue;
            list.add(Component.m_237113_((String)text));
        }
        graphics.m_280666_(Minecraft.m_91087_().f_91062_, list, x - this.f_97735_, y - this.f_97736_);
    }

    public void appendHoverText(GuiGraphics graphics, int x, int y, Component[] texts) {
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        for (Component text : texts) {
            if (text.getString().equals("")) continue;
            list.add(Component.m_237113_((String)text.getString()));
        }
        graphics.m_280666_(Minecraft.m_91087_().f_91062_, list, x - this.f_97735_, y - this.f_97736_);
    }

    public void m_7379_() {
        ((FluidTankContainer)this.m_6262_()).getTile().m_6596_();
        super.m_7379_();
    }

    @Override
    public int getSizeX() {
        return 176;
    }

    @Override
    public int getSizeY() {
        return 198;
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("thoriumreactors", "textures/gui/fluid_tank_gui.png");
    }
}

