/*
 * Decompiled with CFR 0.152.
 */
package unhappycodings.thoriumreactors.common.container.machine;

import com.mojang.blaze3d.vertex.PoseStack;
import java.text.SimpleDateFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;
import unhappycodings.thoriumreactors.common.blockentity.machine.MachineGeneratorBlockEntity;
import unhappycodings.thoriumreactors.common.container.base.screen.MachineScreen;
import unhappycodings.thoriumreactors.common.container.machine.MachineGeneratorContainer;
import unhappycodings.thoriumreactors.common.util.FormattingUtil;
import unhappycodings.thoriumreactors.common.util.ScreenUtil;

public class MachineGeneratorScreen
extends MachineScreen<MachineGeneratorContainer> {
    MachineGeneratorContainer container;

    public MachineGeneratorScreen(MachineGeneratorContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.container = screenContainer;
    }

    @Override
    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTicks, int x, int y) {
        super.m_7286_(graphics, partialTicks, x, y);
        MachineGeneratorBlockEntity entity = this.container.getTile();
        int energyBlitSize = (int)Math.floor(38.0 / (75000.0 / (double)entity.getEnergy()));
        int burnBlitSize = (int)Math.floor(14.0f * ((float)entity.getFuel() / (float)entity.getMaxFuel()));
        graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 18, this.getGuiTop() + 64 + 13 - burnBlitSize, 176, 13 - burnBlitSize, 14, burnBlitSize + (burnBlitSize > 0 ? 1 : 0));
        graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 146, this.getGuiTop() + 22 + (38 - energyBlitSize), 176, 14, 9, energyBlitSize);
        if (entity.getState()) {
            graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 81, this.getGuiTop() + 81, 185, 14, 6, 1);
        } else {
            graphics.m_280218_(this.getTexture(), this.getGuiLeft() + 88, this.getGuiTop() + 81, 185, 15, 6, 1);
        }
    }

    @Override
    protected void m_280003_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY) {
        super.m_280003_(graphics, pMouseX, pMouseY);
        MachineGeneratorBlockEntity entity = this.container.getTile();
        PoseStack pPoseStack = graphics.m_280168_();
        ScreenUtil.drawText(Component.m_237115_((String)"key.categories.inventory").m_130938_(ScreenUtil::notoSans), graphics, 8, 92, 0xAAAAAA);
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(0.7f, 0.7f, 0.7f);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("machines.generator.name")).m_130938_(ScreenUtil::notoSans), graphics, 10, 2, 0xAAAAAA);
        ScreenUtil.drawRightboundText(Component.m_237113_((String)Minecraft.m_91087_().f_91074_.m_6302_()).m_130938_(ScreenUtil::notoSans), graphics, 242, 2, 0xAAAAAA);
        pPoseStack.m_85849_();
        ScreenUtil.drawCenteredText(Component.m_237115_((String)(entity.getState() ? FormattingUtil.getTranslatable("machines.state.running") : FormattingUtil.getTranslatable("machines.state.idle"))).m_130938_(ScreenUtil::notoSans), graphics, 87, 70, 4182051);
        SimpleDateFormat format = new SimpleDateFormat("mm'm' ss's'");
        float fuel = (float)entity.getFuel() / 20.0f * 1000.0f + (float)(entity.getFuel() > 0 ? 1000 : 0);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("machines.text.fuel")).m_130948_(FormattingUtil.hex(708302)).m_7220_((Component)Component.m_237113_((String)format.format(Float.valueOf(fuel))).m_130940_(ChatFormatting.GRAY)).m_130938_(ScreenUtil::notoSans), graphics, 52, 26);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("machines.text.tank")).m_130948_(FormattingUtil.hex(13028414)).m_7220_((Component)Component.m_237113_((String)(entity.getEnergy() + " FE")).m_130940_(ChatFormatting.GRAY)).m_130938_(ScreenUtil::notoSans), graphics, 52, 37);
        ScreenUtil.drawText(Component.m_237115_((String)FormattingUtil.getTranslatable("machines.text.gen")).m_130948_(FormattingUtil.hex(8311637)).m_7220_((Component)Component.m_237113_((String)(entity.getCurrentProduction() + " FE/t")).m_130940_(ChatFormatting.GRAY)).m_130938_(ScreenUtil::notoSans), graphics, 52, 48);
        if (ScreenUtil.mouseInArea(this.getGuiLeft() + 146, this.getGuiTop() + 22, this.getGuiLeft() + 154, this.getGuiTop() + 59, pMouseX, pMouseY)) {
            this.appendHoverText(graphics, pMouseX, pMouseY, new String[]{FormattingUtil.formatNum(entity.getEnergy()) + "/" + FormattingUtil.formatNum(entity.getCapacity()), FormattingUtil.formatPercentNum(entity.getEnergy(), entity.getCapacity())});
        }
    }

    @Override
    public void m_7379_() {
        ((MachineGeneratorContainer)this.m_6262_()).getTile().m_6596_();
        super.m_7379_();
    }

    @Override
    public int getSizeX() {
        return 176;
    }

    @Override
    public int getSizeY() {
        return 184;
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("thoriumreactors", "textures/gui/generator_gui.png");
    }
}

